/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.utils.FileUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public abstract class AyakaLanguage {
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type STRING_ARRAY_TYPE = new TypeToken<String[]>(){}.getType();
    private static final Map<String, AyakaLanguage> languageMap = new HashMap<String, AyakaLanguage>(2);
    private static final String ASSETS = "assets/carpet-ayaka-addition/";
    private static final String LANG_META = "assets/carpet-ayaka-addition/meta/languages.json";
    public static final String DEFAULT_LANG = "en_us";
    private static boolean loaded = false;
    private final String code;

    public static void loadLanguages() {
        block4: {
            if (loaded) {
                return;
            }
            try {
                String[] languages;
                String data = FileUtils.readResource(LANG_META);
                for (String lang : languages = (String[])CarpetAyakaAddition.GSON.fromJson(data, STRING_ARRAY_TYPE)) {
                    lang = lang.toLowerCase(Locale.ROOT);
                    languageMap.put(lang, new AyakaLanguageImpl(lang));
                }
                loaded = true;
            }
            catch (Exception e) {
                CarpetAyakaAddition.LOGGER.error("Failed to load language list", (Throwable)e);
                if (!FabricLoader.getInstance().isDevelopmentEnvironment()) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public static AyakaLanguage get(String lang) {
        return languageMap.computeIfAbsent(lang.toLowerCase(Locale.ROOT), AyakaLanguageEmpty::new);
    }

    public static AyakaLanguage getDefaultLanguage() {
        return languageMap.get(DEFAULT_LANG);
    }

    public static AyakaLanguage getServerLanguage() {
        return AyakaLanguage.get(DEFAULT_LANG);
    }

    public static AyakaLanguage getOrServer(String lang) {
        if (languageMap.containsKey(lang = lang.toLowerCase())) {
            return AyakaLanguage.get(lang);
        }
        return AyakaLanguage.getServerLanguage();
    }

    public AyakaLanguage(String lang) {
        this.code = lang.toLowerCase(Locale.ROOT);
    }

    public String code() {
        return this.code;
    }

    public abstract Map<String, String> translations();

    public abstract String translate(String var1);

    public abstract String translateWithoutFallback(String var1);

    private static class AyakaLanguageImpl
    extends AyakaLanguage {
        private final Map<String, String> translations;

        private AyakaLanguageImpl(String code) {
            super(code);
            Map tr = Collections.emptyMap();
            try {
                String data = FileUtils.readResource(String.format("assets/carpet-ayaka-addition/lang/%s.json", this.code()));
                Map map = (Map)CarpetAyakaAddition.GSON.fromJson(data, MAP_TYPE);
                if (map != null) {
                    tr = map;
                }
            }
            catch (Exception e) {
                CarpetAyakaAddition.LOGGER.error("Failed to load language {}", (Object)this.code(), (Object)e);
            }
            this.translations = Collections.unmodifiableMap(tr);
        }

        @Override
        public Map<String, String> translations() {
            return this.translations;
        }

        @Override
        public String translate(String key) {
            if (AyakaLanguage.DEFAULT_LANG.equals(this.code())) {
                return this.translations.getOrDefault(key, key);
            }
            return this.translations.getOrDefault(key, AyakaLanguageImpl.getDefaultLanguage().translate(key));
        }

        @Override
        public String translateWithoutFallback(String key) {
            return this.translations.get(key);
        }
    }

    private static class AyakaLanguageEmpty
    extends AyakaLanguage {
        public AyakaLanguageEmpty(String code) {
            super(code);
        }

        @Override
        public Map<String, String> translations() {
            return Collections.emptyMap();
        }

        @Override
        public String translate(String key) {
            return AyakaLanguageEmpty.getDefaultLanguage().translate(key);
        }

        @Override
        public String translateWithoutFallback(String key) {
            return null;
        }
    }
}

