/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.commands.address.AddressOld;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Address
implements Comparable<Address> {
    public static final String DESC_PLACEHOLDER = "#none";
    private final String id;
    private final String dim;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private String desc;
    private long weight = 0L;

    public Address(String id, String dim, class_243 pos, String desc, long weight) {
        this.id = id;
        this.dim = dim;
        this.x = pos.field_1352;
        this.y = pos.field_1351;
        this.z = pos.field_1350;
        this.setDesc(desc);
        this.weight = weight;
    }

    public Address(String id, class_5321<class_1937> dim, class_243 pos, String desc, long weight) {
        this(id, dim.method_29177().toString(), pos, desc, weight);
    }

    public Address(AddressOld old) {
        this(old.getId(), old.getDim(), old.getPos(), old.getDesc(), 0L);
    }

    public String getDim() {
        return this.dim;
    }

    public class_5321<class_1937> getDimension() {
        return class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(this.dim));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getId() {
        return this.id;
    }

    public class_243 getPos() {
        return new class_243(this.x, this.y, this.z);
    }

    public String getDesc() {
        return this.desc == null || this.desc.isEmpty() ? DESC_PLACEHOLDER : this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc == null || desc.isEmpty() ? DESC_PLACEHOLDER : desc;
    }

    public long getWeight() {
        return this.weight;
    }

    public void onDetailDisplayed() {
        ++this.weight;
    }

    public void onTeleportedTo() {
        this.weight += 3L;
    }

    @Override
    public int compareTo(@NotNull Address o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.weight == o.weight) {
            return this.id.compareTo(o.id);
        }
        return Long.compare(this.weight, o.weight);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        return Objects.equals(other.id, this.id) && Objects.equals(other.dim, this.dim) && other.getPos().equals((Object)this.getPos()) && Objects.equals(other.desc, this.desc) && other.weight == this.weight;
    }

    public String toString() {
        return String.format("address[id=%s, dim=%s, pos=[%.2f %.2f %.2f], desc=%s]", this.id, this.dim, this.x, this.y, this.z, this.desc);
    }
}

