/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.logging.HUDController;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.commands.c.CCommand;
import com.ayakacraft.carpetayakaaddition.commands.gohome.GoHomeCommand;
import com.ayakacraft.carpetayakaaddition.commands.killitem.KillItemCommand;
import com.ayakacraft.carpetayakaaddition.commands.tpt.TptCommand;
import com.ayakacraft.carpetayakaaddition.commands.waypoint.WaypointCommand;
import com.ayakacraft.carpetayakaaddition.commands.waypoint.WaypointManager;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.ayakacraft.carpetayakaaddition.utils.TickTask;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public final class CarpetAyakaServer
implements CarpetExtension {
    public static final CarpetAyakaServer INSTANCE = new CarpetAyakaServer();
    private final LinkedList<TickTask> tickTasks = new LinkedList();
    private final LinkedBlockingQueue<TickTask> preTickTasks = new LinkedBlockingQueue();
    public MinecraftServer mcServer;

    private CarpetAyakaServer() {
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(CarpetAyakaSettings.class);
        HUDController.register(minecraftServer -> AyakaLoggerRegistry.updateHUD());
    }

    public void onServerLoaded(MinecraftServer server) {
        this.mcServer = server;
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        this.onServerLoadedWorlds$Ayaka();
    }

    public void onTick(MinecraftServer server) {
        this.preTickTasks.forEach(TickTask::start);
        this.preTickTasks.drainTo(this.tickTasks);
        this.tickTasks.forEach(TickTask::tick);
        this.tickTasks.removeIf(TickTask::isFinished);
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        TptCommand.register(dispatcher);
        GoHomeCommand.register(dispatcher);
        WaypointCommand.register(dispatcher);
        CCommand.register(dispatcher);
        KillItemCommand.register(dispatcher);
    }

    public void onServerClosed(MinecraftServer server) {
        WaypointManager.removeWaypointManager(this.mcServer);
        this.cancelTickTasksMatching(it -> true);
        this.mcServer = null;
    }

    public String version() {
        return "carpet-ayaka-addition";
    }

    public void registerLoggers() {
        AyakaLoggerRegistry.registerToCarpet();
    }

    public Map<String, String> canHasTranslations(String lang) {
        String jsonData;
        InputStream langStream = CarpetAyakaServer.class.getClassLoader().getResourceAsStream(String.format("assets/carpet-ayaka-addition/lang/%s.json", lang));
        if (langStream == null) {
            return Collections.emptyMap();
        }
        try {
            byte[] data = new byte[langStream.available()];
            int i = langStream.read(data);
            if (i != data.length) {
                data = Arrays.copyOf(data, i);
            }
            jsonData = new String(data, StandardCharsets.UTF_8);
            langStream.close();
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return (Map)CarpetAyakaAddition.GSON.fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }

    public void addTickTask(TickTask tickTask) {
        this.preTickTasks.add(tickTask);
    }

    public int cancelTickTasksMatching(Predicate<? super TickTask> predicate) {
        int i = 0;
        Iterator each = this.tickTasks.iterator();
        while (each.hasNext()) {
            TickTask task = (TickTask)each.next();
            if (!predicate.test(task)) continue;
            task.cancel();
            each.remove();
            ++i;
        }
        return i;
    }

    public void onServerLoadedWorlds$Ayaka() {
        WaypointManager.getOrCreate(this.mcServer);
    }
}

