/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.waypoint;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.commands.waypoint.Waypoint;
import com.ayakacraft.carpetayakaaddition.commands.waypoint.WaypointManager;
import com.ayakacraft.carpetayakaaddition.utils.CommandUtils;
import com.ayakacraft.carpetayakaaddition.utils.IdentifierUtils;
import com.ayakacraft.carpetayakaaddition.utils.ServerPlayerUtils;
import com.ayakacraft.carpetayakaaddition.utils.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public final class WaypointCommand {
    private static int list(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        WaypointCommand.sendWaypointList(source, WaypointManager.getOrCreate(source.method_9211()).getIDs());
        return 1;
    }

    private static int detail(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        Waypoint waypoint = WaypointManager.getOrCreate(source.method_9211()).get(id);
        if (waypoint == null) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.not_exist", id));
            return 0;
        }
        CommandUtils.sendFeedback(source, TextUtils.joinTexts(new class_2561[]{TextUtils.tr("command.carpet-ayaka-addition.waypoint.detail.1", waypoint.getId()).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), TextUtils.enter(), TextUtils.tr("command.carpet-ayaka-addition.waypoint.detail.2", new Object[0]).method_27692(class_124.field_1060), TextUtils.li(waypoint.getId(), new Object[0]), TextUtils.enter(), TextUtils.tr("command.carpet-ayaka-addition.waypoint.detail.3", new Object[0]).method_27692(class_124.field_1060), TextUtils.li(waypoint.getDim(), new Object[0]), TextUtils.enter(), TextUtils.tr("command.carpet-ayaka-addition.waypoint.detail.4", new Object[0]).method_27692(class_124.field_1060), TextUtils.li(String.format("%.2f %.2f %.2f", waypoint.getX(), waypoint.getY(), waypoint.getZ()), new Object[0]), TextUtils.enter(), TextUtils.tr("command.carpet-ayaka-addition.waypoint.detail.5", new Object[0]).method_27692(class_124.field_1060), TextUtils.li(waypoint.getDesc(), new Object[0])}), false);
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            WaypointManager.getOrCreate(source.method_9211()).load();
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.reload.failed", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.reload.success", new Object[0]), false);
        return 1;
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        String s;
        String id = StringArgumentType.getString(context, (String)"id");
        class_5321 dim = class_2181.method_9289(context, (String)"dim").method_27983();
        class_243 pos = class_2277.method_9736(context, (String)"pos");
        try {
            s = StringArgumentType.getString(context, (String)"desc");
        }
        catch (IllegalArgumentException e) {
            s = "";
        }
        String desc = s;
        class_2168 source = (class_2168)context.getSource();
        try {
            WaypointManager.getOrCreate(source.method_9211()).set(new Waypoint(id, (class_5321<class_1937>)dim, pos, desc));
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.save.failed", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.set.success", id), false);
        return 1;
    }

    private static int remove(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        class_2168 source = (class_2168)context.getSource();
        try {
            if (WaypointManager.getOrCreate(source.method_9211()).remove(id) == null) {
                source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.not_exist", id));
                return 0;
            }
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.save.failed", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.remove.success", id), false);
        return 1;
    }

    private static int tp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        Waypoint waypoint = WaypointManager.getOrCreate(source.method_9211()).get(id);
        class_3222 self = source.method_9207();
        if (waypoint == null) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.not_exist", id));
            return 0;
        }
        class_3218 dim = source.method_9211().method_3847(waypoint.getDimension());
        class_243 pos = waypoint.getPos();
        if (dim == null) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.dimension_unrecognized", waypoint.getDim()));
            return 0;
        }
        if (!dim.method_8621().method_11952(new class_2338(class_3532.method_15357((double)pos.method_10216()), class_3532.method_15357((double)pos.method_10214()), class_3532.method_15357((double)pos.method_10215())))) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.out_of_world_border", id));
            return 0;
        }
        ServerPlayerUtils.teleport(self, dim, pos.method_10216(), pos.method_10214(), pos.method_10215());
        return 1;
    }

    private static int rename(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String oldId = StringArgumentType.getString(context, (String)"oldId");
        String newId = StringArgumentType.getString(context, (String)"id");
        WaypointManager manager = WaypointManager.getOrCreate(source.method_9211());
        if (manager.get(newId) != null) {
            WaypointCommand.remove(context);
        }
        try {
            if (manager.rename(oldId, newId) == null) {
                source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.not_exist", oldId));
                return 0;
            }
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.save.failed", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.rename.success", oldId, newId), false);
        return 1;
    }

    private static int desc(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        WaypointManager manager = WaypointManager.getOrCreate(source.method_9211());
        String id = StringArgumentType.getString(context, (String)"id");
        String desc = StringArgumentType.getString(context, (String)"desc");
        Waypoint w = manager.get(id);
        if (w == null) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.not_exist", id));
            return 0;
        }
        w.setDesc(desc);
        try {
            manager.save();
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.save.failed", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.desc.success", id, desc), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestWaypoints(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(WaypointManager.getOrCreate(((class_2168)context.getSource()).method_9211()).getIDs().stream().map(id -> "\"" + id + "\""), (SuggestionsBuilder)builder);
    }

    private static int listDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String dim = IdentifierUtils.ofWorld((class_1937)class_2181.method_9289(context, (String)"dim")).toString();
        WaypointManager manager = WaypointManager.getOrCreate(source.method_9211());
        Collection<Waypoint> waypoints = manager.getWaypoints();
        List<String> idList = waypoints.stream().filter(w -> Objects.equals(w.getDim(), dim)).map(Waypoint::getId).collect(Collectors.toList());
        WaypointCommand.sendWaypointList(source, idList);
        return 1;
    }

    private static class_2561 waypointIdText(String id) {
        return TextUtils.joinTexts(new class_2561[]{TextUtils.li("[", new Object[0]), TextUtils.li(id, new Object[0]).method_27692(class_124.field_1060), TextUtils.li("] [", new Object[0]), TextUtils.tr("command.carpet-ayaka-addition.waypoint.list.detail", new Object[0]).method_27694(style -> style.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/waypoint detail \"%s\"", id))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.tr("command.carpet-ayaka-addition.waypoint.list.detail.hover", new Object[0])))), TextUtils.li("] [", new Object[0]), TextUtils.tr("command.carpet-ayaka-addition.waypoint.list.tp", new Object[0]).method_27694(style -> style.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/waypoint tp \"%s\"", id))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)TextUtils.tr("command.carpet-ayaka-addition.waypoint.list.tp.hover", new Object[0])))), TextUtils.li("]", new Object[0])});
    }

    private static class_2561 listWaypointIdsText(Collection<String> ids) {
        return TextUtils.join(ids, (class_2561)TextUtils.enter(), WaypointCommand::waypointIdText);
    }

    private static void sendWaypointList(class_2168 source, Collection<String> ids) {
        if (ids.isEmpty()) {
            CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr("command.carpet-ayaka-addition.waypoint.list.empty", new Object[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), false);
        } else {
            CommandUtils.sendFeedback(source, TextUtils.joinTexts(new class_2561[]{TextUtils.tr("command.carpet-ayaka-addition.waypoint.list", new Object[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}), TextUtils.enter(), WaypointCommand.listWaypointIdsText(ids)}), false);
        }
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoint").requires(source -> CommandUtils.checkPermission(source, !CarpetAyakaSettings.commandWaypoint, false))).then(class_2170.method_9247((String)"reload").executes(WaypointCommand::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(WaypointCommand::list)).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(WaypointCommand::listDimension)))).then(class_2170.method_9247((String)"detail").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WaypointCommand::suggestWaypoints).executes(WaypointCommand::detail)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WaypointCommand::suggestWaypoints).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(WaypointCommand::set)).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.string()).executes(WaypointCommand::set))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WaypointCommand::suggestWaypoints).executes(WaypointCommand::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(CommandUtils::isExecutedByPlayer)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WaypointCommand::suggestWaypoints).executes(WaypointCommand::tp)))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"oldId", (ArgumentType)StringArgumentType.string()).suggests(WaypointCommand::suggestWaypoints).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(WaypointCommand::rename))))).then(class_2170.method_9247((String)"desc").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WaypointCommand::suggestWaypoints).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.string()).executes(WaypointCommand::desc)))));
    }
}

