/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.waypoint;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.commands.waypoint.Waypoint;
import com.ayakacraft.carpetayakaaddition.utils.ServerUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class WaypointManager {
    private static final Type COLLECTION_TYPE = new TypeToken<Collection<Waypoint>>(){}.getType();
    private static final HashMap<MinecraftServer, WaypointManager> managerMap = new HashMap(1);
    public static final String WAYPOINT_FILE_NAME = "ayaka_waypoints.json";
    private final Path waypointStoragePath;
    private final LinkedHashMap<String, Waypoint> waypointMap = new LinkedHashMap(3);

    public static WaypointManager getOrCreate(MinecraftServer server) {
        if (managerMap.containsKey(server)) {
            return managerMap.get(server);
        }
        WaypointManager instance = new WaypointManager(server);
        managerMap.put(server, instance);
        return instance;
    }

    public static void removeWaypointManager(MinecraftServer server) {
        if (!managerMap.containsKey(server)) {
            return;
        }
        try {
            managerMap.remove(server).save();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save waypoints", (Throwable)e);
        }
    }

    private WaypointManager(MinecraftServer server) {
        this.waypointStoragePath = ServerUtils.worldRootPath(server).resolve(WAYPOINT_FILE_NAME);
        try {
            this.load();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to load waypoints", (Throwable)e);
        }
    }

    private Waypoint put(Waypoint waypoint) {
        return this.waypointMap.put(waypoint.getId(), waypoint);
    }

    public void load() throws IOException {
        CarpetAyakaAddition.LOGGER.debug("Loading waypoints from {}", (Object)this.waypointStoragePath);
        if (Files.notExists(this.waypointStoragePath, new LinkOption[0]) || !Files.isRegularFile(this.waypointStoragePath, new LinkOption[0])) {
            Files.createFile(this.waypointStoragePath, new FileAttribute[0]);
        }
        String str = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(Files.readAllBytes(this.waypointStoragePath))).toString();
        this.waypointMap.clear();
        Collection obj = (Collection)CarpetAyakaAddition.GSON.fromJson(str, COLLECTION_TYPE);
        if (obj != null) {
            obj.forEach(this::put);
        }
    }

    public void save() throws IOException {
        CarpetAyakaAddition.LOGGER.debug("Saving waypoints to {}", (Object)this.waypointStoragePath);
        Files.write(this.waypointStoragePath, CarpetAyakaAddition.GSON.toJson(this.waypointMap.values(), COLLECTION_TYPE).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public Waypoint get(String id) {
        return this.waypointMap.get(id);
    }

    public Set<String> getIDs() {
        return this.waypointMap.keySet();
    }

    public Collection<Waypoint> getWaypoints() {
        return this.waypointMap.values();
    }

    public Waypoint rename(String oldId, String newId) throws IOException {
        Waypoint w = (Waypoint)this.waypointMap.remove(oldId);
        if (w == null) {
            return null;
        }
        this.put(new Waypoint(newId, w.getDimension(), w.getPos(), w.getDesc()));
        this.save();
        return w;
    }

    public Waypoint remove(String id) throws IOException {
        Waypoint w = (Waypoint)this.waypointMap.remove(id);
        this.save();
        return w;
    }

    public Waypoint set(Waypoint waypoint) throws IOException {
        Waypoint w = this.put(waypoint);
        this.save();
        return w;
    }
}

