/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.mixin.carpet;

import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.Rule;
import carpet.api.settings.SettingsManager;
import carpet.settings.ParsedRule;
import carpet.utils.Translations;
import com.ayakacraft.carpetayakaaddition.settings.conditions.AyakaCondition;
import com.ayakacraft.carpetayakaaddition.settings.conditions.Condition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SettingsManager.class}, remap=false)
public class SettingsManagerMixin {
    @Shadow
    @Final
    private Map<String, CarpetRule<?>> rules;

    @WrapMethod(method={"parseSettingsClass"})
    private void injectConditions(Class<?> settingsClass, Operation<Void> original) {
        Translations.updateLanguage();
        boolean warned = settingsClass == CarpetSettings.class;
        block4: for (Field field : settingsClass.getDeclaredFields()) {
            Class[] conditions;
            Rule newAnnotation = field.getAnnotation(Rule.class);
            carpet.settings.Rule oldAnnotation = field.getAnnotation(carpet.settings.Rule.class);
            if (newAnnotation != null) {
                conditions = newAnnotation.conditions();
            } else {
                if (oldAnnotation == null) continue;
                conditions = oldAnnotation.condition();
                if (!warned) {
                    CarpetSettings.LOG.warn("Registering outdated rules for settings class '{}'!\nThis won't be supported in the future and rules won't be registered!", (Object)settingsClass.getName());
                    warned = true;
                }
            }
            for (Class condition : conditions) {
                try {
                    Constructor constr = condition.getDeclaredConstructor(new Class[0]);
                    constr.setAccessible(true);
                    if (((Rule.Condition)constr.newInstance(new Object[0])).shouldRegister()) continue;
                    continue block4;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Condition conditionAnnotation = field.getAnnotation(Condition.class);
            if (conditionAnnotation != null) {
                for (Class<? extends AyakaCondition> condition : conditionAnnotation.value()) {
                    try {
                        Constructor<? extends AyakaCondition> constr = condition.getDeclaredConstructor(new Class[0]);
                        constr.setAccessible(true);
                        if (constr.newInstance(new Object[0]).shouldRegister()) continue;
                        continue block4;
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            ParsedRule parsed = ParsedRule.of((Field)field, (SettingsManager)((SettingsManager)this));
            this.rules.put(parsed.name(), (CarpetRule<?>)parsed);
        }
    }
}

