/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition;

import carpet.CarpetExtension;
import com.ayakacraft.carpetayakaaddition.commands.AyakaCommandRegistry;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressManager;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.ayakacraft.carpetayakaaddition.settings.AyakaRules;
import com.ayakacraft.carpetayakaaddition.utils.AyakaLanguage;
import com.ayakacraft.carpetayakaaddition.utils.InitializedPerTick;
import com.ayakacraft.carpetayakaaddition.utils.TickTask;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public final class CarpetAyakaServer
implements CarpetExtension {
    public static final CarpetAyakaServer INSTANCE = new CarpetAyakaServer();
    private final LinkedBlockingQueue<TickTask> tickTasks = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<TickTask> scheduledTickTasks = new LinkedBlockingQueue();
    public MinecraftServer mcServer;

    private CarpetAyakaServer() {
    }

    public void onGameStarted() {
        AyakaRules.registerRules();
    }

    public void onServerLoaded(MinecraftServer server) {
        this.mcServer = server;
    }

    public void onTick(MinecraftServer server) {
        this.tickTasks.forEach(TickTask::tick);
        this.tickTasks.removeIf(TickTask::isFinished);
        this.scheduledTickTasks.forEach(TickTask::start);
        this.scheduledTickTasks.drainTo(this.tickTasks);
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        AyakaCommandRegistry.registerCommands(dispatcher);
    }

    public void onServerClosed(MinecraftServer server) {
        AddressManager.removeWaypointManager(this.mcServer);
        this.cancelTickTasksMatching(it -> true);
        this.mcServer = null;
    }

    public String version() {
        return "carpet-ayaka-addition";
    }

    public void registerLoggers() {
        AyakaLoggerRegistry.registerToCarpet();
    }

    public Map<String, String> canHasTranslations(String lang) {
        Map<String, String> original = AyakaLanguage.get(lang).translations();
        HashMap<String, String> transformed = new HashMap<String, String>();
        original.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith("carpet.")).forEach(it -> transformed.put(((String)it.getKey()).substring("carpet.".length()), (String)it.getValue()));
        return transformed;
    }

    public void addTickTask(TickTask tickTask) {
        this.scheduledTickTasks.add(tickTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelTickTasksMatching(Predicate<? super TickTask> filter) {
        int i = 0;
        LinkedBlockingQueue<TickTask> linkedBlockingQueue = this.tickTasks;
        synchronized (linkedBlockingQueue) {
            Iterator<TickTask> each = this.tickTasks.iterator();
            while (each.hasNext()) {
                TickTask task = each.next();
                if (!filter.test(task)) continue;
                task.cancel();
                each.remove();
                ++i;
            }
        }
        return i;
    }

    public void onServerLoadedWorlds$Ayaka() {
        AddressManager.getOrCreate(this.mcServer);
        AyakaLoggerRegistry.ayakaLoggers.forEach(it -> {
            if (it instanceof InitializedPerTick) {
                this.addTickTask(((InitializedPerTick)it).getInitTask(this));
            }
        });
    }
}

