/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils.text;

import com.ayakacraft.carpetayakaaddition.utils.text.TextFormatter;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;

public final class TextUtils {
    private static class_5250 literalText(String str) {
        return class_2561.method_43470((String)str);
    }

    private static class_5250 translatableText(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args);
    }

    @Contract(pure=true)
    public static class_5250 format(String str, Object ... args) {
        return TextFormatter.format(str, args);
    }

    @Contract(pure=true)
    public static class_5250 enter() {
        return class_2561.method_43470((String)System.lineSeparator());
    }

    @Contract(pure=true)
    public static class_5250 space() {
        return class_2561.method_43470((String)" ");
    }

    @Contract(pure=true)
    public static class_5250 empty() {
        return class_2561.method_43470((String)"");
    }

    @Contract(pure=true)
    public static <T> class_2561 join(Collection<T> elements, class_2561 separator, Function<T, class_2561> transformer) {
        return class_2564.method_36332(elements, (class_2561)separator, transformer);
    }

    @Contract(pure=true)
    public static class_2561 joinTexts(Collection<class_2561> elements) {
        return TextUtils.join(elements, (class_2561)TextUtils.empty(), Function.identity());
    }

    @Contract(pure=true)
    public static class_2561 joinTexts(class_2561[] elements) {
        return TextUtils.joinTexts(Arrays.asList(elements));
    }

    public static void sendMessageToServer(MinecraftServer server, class_2561 text) {
        server.method_43496(text);
    }

    public static void broadcast(MinecraftServer server, class_2561 txt, boolean overlay) {
        TextUtils.sendMessageToServer(server, txt);
        server.method_3760().method_14571().forEach(p -> p.method_7353(txt, overlay));
    }

    public static void broadcast(MinecraftServer server, class_2561 textForServer, Function<class_3222, class_2561> textFunction, boolean overlay) {
        TextUtils.sendMessageToServer(server, textForServer);
        server.method_3760().method_14571().forEach(player -> {
            class_2561 t = (class_2561)textFunction.apply((class_3222)player);
            if (t != null) {
                player.method_7353(t, overlay);
            }
        });
    }

    public static void broadcastTranslatable(MinecraftServer server, boolean overlay, Translator tr, Object ... args) {
        TextUtils.broadcast(server, (class_2561)tr.tr(null, args), p -> tr.tr((class_3222)p, null, args), overlay);
    }

    @Contract(mutates="param1")
    public static class_5250 withCommand(class_5250 text, String command) {
        text.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(command)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)command))));
        return text;
    }
}

