/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.commands.address.Address;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressManager;
import com.ayakacraft.carpetayakaaddition.utils.CommandUtils;
import com.ayakacraft.carpetayakaaddition.utils.ServerPlayerUtils;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class AddressCommand {
    private static int list(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        AddressCommand.sendWaypointList(source, AddressManager.getOrCreate(source.method_9211()).getIDs());
        return 1;
    }

    private static int detail(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        Address address = AddressManager.getOrCreate(source.method_9211()).get(id);
        if (address == null) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.not_exist", id));
            return 0;
        }
        CommandUtils.sendFeedback(source, TextUtils.joinTexts(new class_2561[]{TextUtils.tr(source, "command.carpet-ayaka-addition.address.detail.0", address.getId()).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), TextUtils.enter(), TextUtils.tr(source, "command.carpet-ayaka-addition.address.detail.1", new Object[0]).method_10854(class_124.field_1060), new class_2585(address.getId()), TextUtils.enter(), TextUtils.tr(source, "command.carpet-ayaka-addition.address.detail.2", new Object[0]).method_10854(class_124.field_1060), new class_2585(address.getDim()), TextUtils.enter(), TextUtils.tr(source, "command.carpet-ayaka-addition.address.detail.3", new Object[0]).method_10854(class_124.field_1060), TextUtils.format("%.2f %.2f %.2f", address.getX(), address.getY(), address.getZ()), TextUtils.enter(), TextUtils.tr(source, "command.carpet-ayaka-addition.address.detail.4", new Object[0]).method_10854(class_124.field_1060), new class_2585(address.getDesc())}), false);
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            AddressManager.getOrCreate(source.method_9211()).load();
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.reload.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.reload.success", new Object[0]), false);
        return 1;
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        String s;
        String id = StringArgumentType.getString(context, (String)"id");
        class_2874 dim = class_2181.method_9289(context, (String)"dim");
        class_243 pos = class_2277.method_9736(context, (String)"pos");
        try {
            s = StringArgumentType.getString(context, (String)"desc");
        }
        catch (IllegalArgumentException e) {
            s = "";
        }
        String desc = s;
        class_2168 source = (class_2168)context.getSource();
        try {
            AddressManager.getOrCreate(source.method_9211()).set(new Address(id, dim, pos, desc));
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.set.success", id), false);
        return 1;
    }

    private static int remove(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        class_2168 source = (class_2168)context.getSource();
        try {
            if (AddressManager.getOrCreate(source.method_9211()).remove(id) == null) {
                source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.not_exist", id));
                return 0;
            }
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.save.failed", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.remove.success", id), false);
        return 1;
    }

    private static int tp(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String id = StringArgumentType.getString(context, (String)"id");
        Address address = AddressManager.getOrCreate(source.method_9211()).get(id);
        class_3222 self = source.method_9207();
        if (address == null) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.not_exist", id));
            return 0;
        }
        class_3218 dim = source.method_9211().method_3847(address.getDimension());
        class_243 pos = address.getPos();
        if (dim == null) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.tp.dimension_unrecognized", address.getDim()));
            return 0;
        }
        if (!dim.method_8621().method_11952(new class_2338(class_3532.method_15357((double)pos.method_10216()), class_3532.method_15357((double)pos.method_10214()), class_3532.method_15357((double)pos.method_10215())))) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.tp.out_of_world_border", id));
            return 0;
        }
        ServerPlayerUtils.teleport(self, dim, pos.method_10216(), pos.method_10214(), pos.method_10215());
        return 1;
    }

    private static int rename(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String oldId = StringArgumentType.getString(context, (String)"oldId");
        String newId = StringArgumentType.getString(context, (String)"id");
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        try {
            if (manager.rename(oldId, newId) == null) {
                source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.not_exist", oldId));
                return 0;
            }
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.rename.success", oldId, newId), false);
        return 1;
    }

    private static int desc(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        String id = StringArgumentType.getString(context, (String)"id");
        String desc = StringArgumentType.getString(context, (String)"desc");
        Address w = manager.get(id);
        if (w == null) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.not_exist", id));
            return 0;
        }
        w.setDesc(desc);
        try {
            manager.save();
        }
        catch (IOException e) {
            source.method_9213((class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.save.failure", new Object[0]));
            return 0;
        }
        CommandUtils.sendFeedback(source, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.desc.success", id, desc), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestWaypoints(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(AddressManager.getOrCreate(((class_2168)context.getSource()).method_9211()).getIDs().stream().map(id -> "\"" + id + "\""), (SuggestionsBuilder)builder);
    }

    private static int listDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String dim = String.valueOf(class_2874.method_12485((class_2874)class_2181.method_9289(context, (String)"dim")));
        AddressManager manager = AddressManager.getOrCreate(source.method_9211());
        Collection<Address> addresses = manager.getWaypoints();
        List<String> idList = addresses.stream().filter(w -> Objects.equals(w.getDim(), dim)).map(Address::getId).collect(Collectors.toList());
        AddressCommand.sendWaypointList(source, idList);
        return 1;
    }

    private static class_2561 waypointIdText(String id, class_2168 source) {
        return TextUtils.format("[{}] [{}] [{}]", new class_2585(id).method_10854(class_124.field_1060), TextUtils.tr(source, "command.carpet-ayaka-addition.address.list.detail", new Object[0]).method_10859(style -> style.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/ad detail \"%s\"", id))).method_10949(new class_2568(class_2568.class_2569.field_11762, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.list.detail.hover", new Object[0])))), TextUtils.tr(source, "command.carpet-ayaka-addition.address.list.tp", new Object[0]).method_10859(style -> style.method_10977(class_124.field_1061).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("/ad tp \"%s\"", id))).method_10949(new class_2568(class_2568.class_2569.field_11762, (class_2561)TextUtils.tr(source, "command.carpet-ayaka-addition.address.list.tp.hover", new Object[0])))));
    }

    private static class_2561 listWaypointIdsText(Collection<String> ids, class_2168 source) {
        return TextUtils.join(ids, (class_2561)TextUtils.enter(), id -> AddressCommand.waypointIdText(id, source));
    }

    private static void sendWaypointList(class_2168 source, Collection<String> ids) {
        if (ids.isEmpty()) {
            CommandUtils.sendFeedback(source, TextUtils.tr(source, "command.carpet-ayaka-addition.address.list.empty", new Object[0]).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), false);
        } else {
            CommandUtils.sendFeedback(source, TextUtils.joinTexts(new class_2561[]{TextUtils.tr(source, "command.carpet-ayaka-addition.address.list", new Object[0]).method_10856(new class_124[]{class_124.field_1054, class_124.field_1067}), TextUtils.enter(), AddressCommand.listWaypointIdsText(ids, source)}), false);
        }
    }

    private static LiteralArgumentBuilder<class_2168> registerSubCommands(LiteralArgumentBuilder<class_2168> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> CommandUtils.checkPermission(source, !CarpetAyakaSettings.commandAddress, false))).then(class_2170.method_9247((String)"reload").executes(AddressCommand::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(AddressCommand::list)).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).executes(AddressCommand::listDimension)))).then(class_2170.method_9247((String)"detail").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::detail)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).then(class_2170.method_9244((String)"dim", (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(AddressCommand::set)).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.string()).executes(AddressCommand::set))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(source -> source.method_9228() instanceof class_3222)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).executes(AddressCommand::tp)))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"oldId", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(AddressCommand::rename))))).then(class_2170.method_9247((String)"desc").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(AddressCommand::suggestWaypoints).then(class_2170.method_9244((String)"desc", (ArgumentType)StringArgumentType.string()).executes(AddressCommand::desc))));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(AddressCommand.registerSubCommands((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"address")));
        dispatcher.register(AddressCommand.registerSubCommands((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"ad")));
    }
}

