/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.commands.address.Address;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressOld;
import com.ayakacraft.carpetayakaaddition.utils.MathUtils;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAddress<D>
implements Comparable<AbstractAddress<D>> {
    public static final String DESC_PLACEHOLDER = "#none";
    public static final String XAERO_WAYPOINT_FORMAT = "xaero-waypoint:%s:%s:%d:%d:%d:0:false:0:Internal-%s-waypoints";
    protected final String id;
    protected final String dim;
    protected final double x;
    protected final double y;
    protected final double z;
    @Nullable
    protected String desc;
    protected long weight = 0L;
    protected boolean pinned = false;

    @Contract(pure=true)
    public static Address fromOld(AddressOld old) {
        return new Address(old.id, old.dim, old.pos, old.desc, 0L);
    }

    public AbstractAddress(String id, String dim, class_243 pos, String desc, long weight) {
        this.id = id;
        this.dim = dim;
        this.x = pos.field_1352;
        this.y = pos.field_1351;
        this.z = pos.field_1350;
        this.setDesc(desc);
        this.weight = weight;
    }

    public AbstractAddress(String id, D dim, class_243 pos, String desc, long weight) {
        this.id = id;
        this.dim = this.transDim(dim);
        this.x = pos.field_1352;
        this.y = pos.field_1351;
        this.z = pos.field_1350;
        this.setDesc(desc);
        this.weight = weight;
    }

    @Contract(pure=true)
    protected abstract String transDim(D var1);

    @Contract(pure=true)
    public String getDim() {
        return this.dim;
    }

    @Contract(pure=true)
    public abstract D getDimension();

    @Contract(pure=true)
    public double getX() {
        return this.x;
    }

    @Contract(pure=true)
    public double getY() {
        return this.y;
    }

    @Contract(pure=true)
    public double getZ() {
        return this.z;
    }

    @Contract(pure=true)
    public String getId() {
        return this.id;
    }

    @Contract(pure=true)
    public class_243 getPos() {
        return new class_243(this.x, this.y, this.z);
    }

    @Contract(pure=true)
    public String getDesc() {
        return this.desc == null || this.desc.isEmpty() ? DESC_PLACEHOLDER : this.desc;
    }

    @Contract(pure=true)
    public void setDesc(String desc) {
        this.desc = desc == null || desc.isEmpty() ? DESC_PLACEHOLDER : desc;
    }

    @Contract(pure=true)
    public long getWeight() {
        return this.weight;
    }

    @Contract(pure=true)
    public class_1923 getChunkPos() {
        return MathUtils.getChunkPos(this.getPos());
    }

    @Contract(pure=true)
    public String getXaeroWaypointString() {
        return String.format(XAERO_WAYPOINT_FORMAT, this.id, Character.valueOf(this.id.charAt(0)), (int)this.x, (int)this.y, (int)this.z, new class_2960(this.dim).method_12832().replace('_', '-'));
    }

    @Contract(pure=true)
    public abstract boolean isInWorld(class_1937 var1);

    @Contract(mutates="this")
    public void onDetailDisplayed() {
        ++this.weight;
    }

    @Contract(mutates="this")
    public void onTeleportedTo() {
        this.weight += 3L;
    }

    @Contract(mutates="this")
    public void reduceWeight() {
        this.weight = this.weight > 1L ? this.weight * 15L >> 4 : 0L;
    }

    @Contract(pure=true)
    public boolean isPinned() {
        return this.pinned;
    }

    @Contract(mutates="this")
    public void pin() {
        this.pinned = true;
    }

    @Contract(mutates="this")
    public void unpin() {
        this.pinned = false;
    }

    @Override
    @Contract(pure=true)
    public int compareTo(@NotNull AbstractAddress<D> o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.weight == o.weight ? this.id.compareTo(o.id) : (this.weight > o.weight ? 1 : -1);
    }

    @Contract(pure=true)
    public boolean equals(Object o) {
        if (!(o instanceof Address)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Address other = (Address)o;
        return Objects.equals(other.id, this.id) && Objects.equals(other.dim, this.dim) && other.getPos().equals((Object)this.getPos()) && Objects.equals(other.desc, this.desc) && other.weight == this.weight;
    }

    @Contract(pure=true)
    public String toString() {
        return String.format("address[id=%s, dim=%s, pos=[%.2f %.2f %.2f], desc=%s]", this.id, this.dim, this.x, this.y, this.z, this.desc);
    }
}

