/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.helpers.mods;

import carpet.patches.EntityPlayerMPFake;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.utils.ModUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dubhe.gugle.carpet.GcaSetting;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public final class GcaHelper {
    private static final Method savePlayerMethod;

    private static JsonElement invokeSavePlayer(class_3222 player) {
        try {
            if (savePlayerMethod != null) {
                return (JsonElement)savePlayerMethod.invoke(null, player);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            CarpetAyakaAddition.LOGGER.warn("Failed to invoke save player method in GCA, fakePlayerResidentBackupFix might not work", (Throwable)e);
        }
        return null;
    }

    public static void storeFakesIfNeeded(MinecraftServer server) {
        if (!GcaSetting.fakePlayerResident || server.method_3750() || savePlayerMethod == null) {
            return;
        }
        CarpetAyakaAddition.LOGGER.debug("Saving fake players");
        JsonObject fakePlayerList = new JsonObject();
        server.method_3760().method_14571().stream().filter(player -> player instanceof EntityPlayerMPFake && !player.method_5647(new class_2487()).method_10545("gca.NoResident")).forEach(p -> fakePlayerList.add(p.method_5477().getString(), GcaHelper.invokeSavePlayer(p)));
        Path path = server.method_27050(class_5218.field_24188).resolve("fake_player.gca.json");
        try {
            Files.write(path, CarpetAyakaAddition.GSON.toJson((JsonElement)fakePlayerList).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        Method spm;
        block5: {
            spm = null;
            try {
                Optional<ModContainer> o = ModUtils.getModContainer("gca");
                if (o.isPresent()) {
                    Class<?> clazz;
                    ClassLoader classLoader = GcaHelper.class.getClassLoader();
                    try {
                        clazz = classLoader.loadClass("dev.dubhe.gugle.carpet.tools.FakePlayerResident");
                    }
                    catch (ClassNotFoundException e) {
                        clazz = classLoader.loadClass("dev.dubhe.gugle.carpet.tools.player.FakePlayerResident");
                    }
                    spm = clazz.getDeclaredMethod("save", class_1657.class);
                    spm.setAccessible(true);
                    break block5;
                }
                CarpetAyakaAddition.LOGGER.warn("GCA not loaded, fakePlayerResidentBackupFix won't be activated");
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                CarpetAyakaAddition.LOGGER.warn("Failed to load GCA, fakePlayerResidentBackupFix won't be activated", (Throwable)e);
            }
        }
        savePlayerMethod = spm;
    }
}

