/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.logging.HUDController;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.commands.AyakaCommandRegistry;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressManager;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.ayakacraft.carpetayakaaddition.utils.AyakaLanguage;
import com.ayakacraft.carpetayakaaddition.utils.InitializedPerTick;
import com.ayakacraft.carpetayakaaddition.utils.TickTask;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public final class CarpetAyakaServer
implements CarpetExtension {
    public static final CarpetAyakaServer INSTANCE = new CarpetAyakaServer();
    private final LinkedList<TickTask> tickTasks = new LinkedList();
    private final LinkedBlockingQueue<TickTask> scheduledTickTasks = new LinkedBlockingQueue();
    public MinecraftServer mcServer;

    private CarpetAyakaServer() {
    }

    public void onGameStarted() {
        CarpetServer.settingsManager.parseSettingsClass(CarpetAyakaSettings.class);
        HUDController.register(minecraftServer -> AyakaLoggerRegistry.updateHUD());
    }

    public void onServerLoaded(MinecraftServer server) {
        this.mcServer = server;
    }

    public void onServerLoadedWorlds(MinecraftServer server) {
        this.onServerLoadedWorlds$Ayaka();
    }

    public void onTick(MinecraftServer server) {
        this.tickTasks.forEach(TickTask::tick);
        this.tickTasks.removeIf(TickTask::isFinished);
        this.scheduledTickTasks.forEach(TickTask::start);
        this.scheduledTickTasks.drainTo(this.tickTasks);
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        AyakaCommandRegistry.registerCommands(dispatcher);
    }

    public void onServerClosed(MinecraftServer server) {
        AddressManager.removeWaypointManager(this.mcServer);
        this.cancelTickTasksMatching(it -> true);
        this.mcServer = null;
    }

    public String version() {
        return "carpet-ayaka-addition";
    }

    public void registerLoggers() {
        AyakaLoggerRegistry.registerToCarpet();
    }

    public Map<String, String> canHasTranslations(String lang) {
        return AyakaLanguage.get(lang).translations();
    }

    public void addTickTask(TickTask tickTask) {
        this.scheduledTickTasks.add(tickTask);
    }

    public synchronized int cancelTickTasksMatching(Predicate<? super TickTask> filter) {
        int i = 0;
        Iterator each = this.tickTasks.iterator();
        while (each.hasNext()) {
            TickTask task = (TickTask)each.next();
            if (!filter.test(task)) continue;
            task.cancel();
            each.remove();
            ++i;
        }
        return i;
    }

    public void onServerLoadedWorlds$Ayaka() {
        AddressManager.getOrCreate(this.mcServer);
        AyakaLoggerRegistry.ayakaLoggers.forEach(it -> {
            if (it instanceof InitializedPerTick) {
                this.addTickTask(((InitializedPerTick)it).getInitTask(this));
            }
        });
    }
}

