/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.mixin.carpet;

import carpet.settings.ParsedRule;
import carpet.settings.Rule;
import carpet.settings.SettingsManager;
import com.ayakacraft.carpetayakaaddition.settings.conditions.AyakaCondition;
import com.ayakacraft.carpetayakaaddition.settings.conditions.Condition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SettingsManager.class}, remap=false)
public class SettingsManagerMixin {
    @Unique
    private static final Constructor<ParsedRule> parsedRuleConstructor;
    @Shadow
    private Map<String, ParsedRule<?>> rules;

    @Unique
    private static ParsedRule<?> of(Field field, Rule rule) {
        try {
            return parsedRuleConstructor.newInstance(field, rule);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @WrapMethod(method={"parseSettingsClass"})
    private void injectConditions(Class<?> settingsClass, Operation<Void> original) {
        block2: for (Field f : settingsClass.getDeclaredFields()) {
            Rule rule = f.getAnnotation(Rule.class);
            if (rule == null) continue;
            ParsedRule<?> parsed = SettingsManagerMixin.of(f, rule);
            Condition conditionAnnotation = f.getAnnotation(Condition.class);
            if (conditionAnnotation != null) {
                for (Class<? extends AyakaCondition> condition : conditionAnnotation.value()) {
                    try {
                        Constructor<? extends AyakaCondition> constr = condition.getDeclaredConstructor(new Class[0]);
                        constr.setAccessible(true);
                        if (constr.newInstance(new Object[0]).shouldRegister()) continue;
                        continue block2;
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
            this.rules.put(parsed.name, parsed);
        }
    }

    static {
        try {
            parsedRuleConstructor = ParsedRule.class.getDeclaredConstructor(Field.class, Rule.class);
            parsedRuleConstructor.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

