/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.logging.loadedchunks;

import com.ayakacraft.carpetayakaaddition.logging.AbstractAyakaHUDLoggerSingleLine;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.ayakacraft.carpetayakaaddition.utils.InitializedPerTick;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class LoadedChunksLogger
extends AbstractAyakaHUDLoggerSingleLine
implements InitializedPerTick {
    private static final String[] OPTIONS = new String[]{"all", "dynamic", "overworld", "the_nether", "the_end"};
    private static final short DEFAULT_INDEX = 1;
    private static final String FORMAT = "%d/%d";
    private static final class_2561 SEPARATOR = new class_2585("/").method_27692(class_124.field_1080);
    private static final class_2960 OVW_ID = new class_2960("minecraft:overworld");
    private static final class_2960 NETHER_ID = new class_2960("minecraft:the_nether");
    private static final class_2960 END_ID = new class_2960("minecraft:the_end");
    public static final String NAME = "loadedChunks";
    public static final LoadedChunksLogger INSTANCE;
    public final Map<class_2960, Integer> loadedChunksCount = new LinkedHashMap<class_2960, Integer>(3);
    public final Map<class_2960, Integer> loadedChunksCountP = new LinkedHashMap<class_2960, Integer>(3);
    public int loadedChunksCountAll = 0;
    public int loadedChunksCountAllP = 0;

    private LoadedChunksLogger() throws NoSuchFieldException {
        super(NAME, OPTIONS[1], OPTIONS, true);
    }

    @Override
    public void init() {
        this.loadedChunksCountAll = 0;
        this.loadedChunksCountAllP = 0;
        this.loadedChunksCount.clear();
        this.loadedChunksCountP.clear();
    }

    @Override
    public boolean isEnabled() {
        return AyakaLoggerRegistry.__loadedChunks;
    }

    @Override
    public class_2554 updateSingleLine(String playerOption, class_1657 player) {
        class_2554 value;
        class_5250 header = TextUtils.tr((class_3222)player, "carpet-ayaka-addition.logger.loadedChunks", new Object[0]).method_27692(class_124.field_1080);
        if (OPTIONS[1].equals(playerOption)) {
            playerOption = ((class_3222)player).method_14220().method_27983().method_29177().method_12832();
        }
        if (OPTIONS[0].equals(playerOption)) {
            LinkedList<class_5250> txtList = new LinkedList<class_5250>();
            txtList.add(header);
            txtList.add(TextUtils.format(FORMAT, this.loadedChunksCountAllP, this.loadedChunksCountAll).method_27692(class_124.field_1080));
            this.loadedChunksCount.keySet().stream().map(this::getCountText).forEach(txtList::add);
            value = TextUtils.join(txtList, (class_2561)TextUtils.space(), Function.identity());
        } else {
            value = OPTIONS[2].equals(playerOption) ? TextUtils.format("{} {}", header, this.getCountText(OVW_ID)) : (OPTIONS[3].equals(playerOption) ? TextUtils.format("{} {}", header, this.getCountText(NETHER_ID)) : (OPTIONS[4].equals(playerOption) ? TextUtils.format("{} {}", header, this.getCountText(END_ID)) : null));
        }
        return value;
    }

    public class_2561 getCountText(class_2960 id) {
        class_2554 t1 = TextUtils.li(this.loadedChunksCountP.getOrDefault(id, 0));
        class_2554 t2 = TextUtils.li(this.loadedChunksCount.getOrDefault(id, 0));
        if (OVW_ID.equals((Object)id)) {
            t1.method_27692(class_124.field_1077);
            t2.method_27692(class_124.field_1077);
        } else if (NETHER_ID.equals((Object)id)) {
            t1.method_27692(class_124.field_1079);
            t2.method_27692(class_124.field_1079);
        } else if (END_ID.equals((Object)id)) {
            t1.method_27692(class_124.field_1062);
            t2.method_27692(class_124.field_1062);
        }
        return TextUtils.format("{}{}{}", t1, SEPARATOR, t2);
    }

    static {
        LoadedChunksLogger i = null;
        try {
            i = new LoadedChunksLogger();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        INSTANCE = i;
    }
}

