/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.logging.poi;

import com.ayakacraft.carpetayakaaddition.logging.AbstractAyakaLogger;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.ayakacraft.carpetayakaaddition.utils.RegistryUtils;
import com.ayakacraft.carpetayakaaddition.utils.StringUtils;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_4158;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7473;

public class POILogger
extends AbstractAyakaLogger {
    private static final String[] OPTIONS = new String[]{"all", "village", "bee_home", "acquirable_job_site"};
    private static final short DEFAULT_INDEX = 0;
    private static final Map<String, class_6862<class_4158>> POI_TAGS = Maps.newHashMap();
    public static final String NAME = "poi";
    public static final POILogger INSTANCE;
    public static final Translator TR;

    private POILogger() throws NoSuchFieldException {
        super(NAME, OPTIONS[0], OPTIONS, true);
    }

    private class_5250[] doAddedLogging(class_2338 pos, class_6880<class_4158> type, String option, class_3222 player) {
        block3: {
            block2: {
                if (OPTIONS[0].equals(option)) break block2;
                if (!type.method_40228().anyMatch(arg_0 -> POI_TAGS.get(option).equals(arg_0))) break block3;
            }
            return new class_5250[]{TR.tr(player, "added", StringUtils.posString((class_2382)class_4076.method_18682((class_2338)pos)), StringUtils.posString((class_2382)pos), RegistryUtils.getIdAsString(type))};
        }
        return null;
    }

    private class_5250[] doRemovedLogging(class_2338 pos, class_3222 player) {
        return new class_5250[]{TR.tr(player, "removed", StringUtils.posString((class_2382)class_4076.method_18682((class_2338)pos)), StringUtils.posString((class_2382)pos))};
    }

    private class_5250[] doTickedReservedLogging(class_2338 pos, class_6880<class_4158> type, int freeTickets, String option, class_3222 player) {
        block3: {
            block2: {
                if (OPTIONS[0].equals(option)) break block2;
                if (!type.method_40228().anyMatch(arg_0 -> POI_TAGS.get(option).equals(arg_0))) break block3;
            }
            return new class_5250[]{TR.tr(player, "ticket_reserved", StringUtils.posString((class_2382)class_4076.method_18682((class_2338)pos)), StringUtils.posString((class_2382)pos), RegistryUtils.getIdAsString(type), freeTickets, ((class_4158)type.comp_349()).comp_816())};
        }
        return null;
    }

    private class_5250[] doTickedReleasedLogging(class_2338 pos, class_6880<class_4158> type, int freeTickets, String option, class_3222 player) {
        block3: {
            block2: {
                if (OPTIONS[0].equals(option)) break block2;
                if (!type.method_40228().anyMatch(arg_0 -> POI_TAGS.get(option).equals(arg_0))) break block3;
            }
            class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
            return new class_5250[]{TR.tr(player, "ticket_released", StringUtils.posString((class_2382)sectionPos), StringUtils.posString((class_2382)pos), RegistryUtils.getIdAsString(type), freeTickets, ((class_4158)type.comp_349()).comp_816())};
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return AyakaLoggerRegistry.__poi;
    }

    public void onAdded(class_2338 pos, class_6880<class_4158> type) {
        if (this.isEnabled()) {
            this.log((playerOption, player) -> this.doAddedLogging(pos, type, playerOption, (class_3222)player));
        }
    }

    public void onRemoved(class_2338 pos) {
        if (this.isEnabled()) {
            this.log((playerOption, player) -> this.doRemovedLogging(pos, (class_3222)player));
        }
    }

    public void onTicketReserved(class_2338 pos, class_6880<class_4158> type, int freeTickets) {
        if (this.isEnabled()) {
            this.log((playerOption, player) -> this.doTickedReservedLogging(pos, type, freeTickets, playerOption, (class_3222)player));
        }
    }

    public void onTicketReleased(class_2338 pos, class_6880<class_4158> type, int freeTickets) {
        if (this.isEnabled()) {
            this.log((playerOption, player) -> this.doTickedReleasedLogging(pos, type, freeTickets, playerOption, (class_3222)player));
        }
    }

    static {
        TR = AyakaLoggerRegistry.LOGGER_TR.resolve(NAME);
        POILogger i = null;
        try {
            i = new POILogger();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        INSTANCE = i;
        POI_TAGS.put("village", (class_6862<class_4158>)class_7473.field_39263);
        POI_TAGS.put("bee_home", (class_6862<class_4158>)class_7473.field_39264);
        POI_TAGS.put("acquirable_job_site", (class_6862<class_4158>)class_7473.field_39262);
    }
}

