/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.commands.address.Address;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressOld;
import com.ayakacraft.carpetayakaaddition.utils.FileUtils;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_2874;
import net.minecraft.server.MinecraftServer;

public class AddressManager {
    @Deprecated
    private static final Type COLLECTION_TYPE_OLD = new TypeToken<Collection<AddressOld>>(){}.getType();
    private static final Type MAP_TYPE = new TypeToken<TreeMap<String, Address>>(){}.getType();
    private static final HashMap<MinecraftServer, AddressManager> managerMap = new HashMap(1);
    @Deprecated
    public static final String WAYPOINT_FILE_NAME_OLD = "ayaka_waypoints.json";
    public static final String WAYPOINT_FILE_NAME = "ayaka_addresses.json";
    @Deprecated
    private final Path waypointStoragePathOld;
    private final Path waypointStoragePath;
    private final TreeMap<String, Address> addressMap = new TreeMap();

    @Deprecated
    private static Collection<AddressOld> loadFromPathOld(Path storagePath) throws IOException {
        String str = FileUtils.readString(storagePath);
        Collection addresses = (Collection)CarpetAyakaAddition.GSON.fromJson(str, COLLECTION_TYPE_OLD);
        return addresses == null ? Collections.emptyList() : addresses;
    }

    private static Map<String, Address> loadFromPath(Path storagePath) throws IOException {
        String str = FileUtils.readString(storagePath);
        Map addresses = (Map)CarpetAyakaAddition.GSON.fromJson(str, MAP_TYPE);
        return addresses == null ? Collections.emptyMap() : addresses;
    }

    public static AddressManager getOrCreate(MinecraftServer server) {
        if (managerMap.containsKey(server)) {
            return managerMap.get(server);
        }
        AddressManager instance = new AddressManager(server);
        managerMap.put(server, instance);
        return instance;
    }

    public static void removeWaypointManager(MinecraftServer server) {
        if (!managerMap.containsKey(server)) {
            return;
        }
        try {
            managerMap.remove(server).save();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
        }
    }

    private AddressManager(MinecraftServer server) {
        this.waypointStoragePath = server.method_3847(class_2874.field_13072).method_17982().method_132().toPath().resolve(WAYPOINT_FILE_NAME);
        this.waypointStoragePathOld = server.method_3847(class_2874.field_13072).method_17982().method_132().toPath().resolve(WAYPOINT_FILE_NAME_OLD);
        try {
            this.load();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to load addresses", (Throwable)e);
        }
    }

    private void put(AddressOld addressOld) {
        this.put(new Address(addressOld));
    }

    private Address put(Address address) {
        CarpetAyakaAddition.LOGGER.debug("Put address {}", (Object)address);
        return this.addressMap.put(address.getId(), address);
    }

    public void load() throws IOException {
        this.addressMap.clear();
        if (Files.isRegularFile(this.waypointStoragePathOld, new LinkOption[0])) {
            CarpetAyakaAddition.LOGGER.warn("Loading addresses from {} which is deprecated", (Object)this.waypointStoragePathOld);
            AddressManager.loadFromPathOld(this.waypointStoragePathOld).forEach(this::put);
            Files.delete(this.waypointStoragePathOld);
        }
        if (Files.isRegularFile(this.waypointStoragePath, new LinkOption[0])) {
            CarpetAyakaAddition.LOGGER.debug("Loading addresses from {}", (Object)this.waypointStoragePath);
            try {
                this.addressMap.putAll(AddressManager.loadFromPath(this.waypointStoragePath));
            }
            catch (JsonSyntaxException e) {
                CarpetAyakaAddition.LOGGER.warn("Loading addresses from {} with old form which is deprecated", (Object)this.waypointStoragePath);
                AddressManager.loadFromPathOld(this.waypointStoragePath).forEach(this::put);
            }
        }
        this.save();
    }

    public void save() throws IOException {
        CarpetAyakaAddition.LOGGER.debug("Saving addresses to {}", (Object)this.waypointStoragePath);
        Files.write(this.waypointStoragePath, CarpetAyakaAddition.GSON.toJson(this.addressMap, MAP_TYPE).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public Address get(String id) {
        return this.addressMap.get(id);
    }

    public Set<String> getIDs() {
        return this.addressMap.keySet();
    }

    public Collection<Address> getAddresses() {
        return this.addressMap.values();
    }

    public Address rename(String oldId, String newId) throws IOException {
        Address w = this.addressMap.remove(oldId);
        if (w == null) {
            return null;
        }
        Address a = new Address(newId, w.getDim(), w.getPos(), w.getDesc(), w.getWeight());
        if (this.put(a) != null) {
            CarpetAyakaAddition.LOGGER.warn("Address named {} already exists", (Object)newId);
        }
        CarpetAyakaAddition.LOGGER.debug("Renaming {} to {}", (Object)w, (Object)a);
        this.save();
        return w;
    }

    public Address remove(String id) throws IOException {
        Address w = this.addressMap.remove(id);
        CarpetAyakaAddition.LOGGER.debug("Removed address {}", (Object)w);
        this.save();
        return w;
    }

    public Address set(Address address) throws IOException {
        Address w = this.put(address);
        CarpetAyakaAddition.LOGGER.debug("Set address {}", (Object)address);
        this.save();
        return w;
    }
}

