/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaServer;
import com.ayakacraft.carpetayakaaddition.commands.address.AbstractAddress;
import com.ayakacraft.carpetayakaaddition.commands.address.Address;
import com.ayakacraft.carpetayakaaddition.commands.address.AddressOld;
import com.ayakacraft.carpetayakaaddition.utils.FileUtils;
import com.ayakacraft.carpetayakaaddition.utils.TickTask;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2874;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Contract;

public class AddressManager {
    @Deprecated
    private static final Type COLLECTION_TYPE_OLD = new TypeToken<Collection<AddressOld>>(){}.getType();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Address>>(){}.getType();
    private static final Map<MinecraftServer, AddressManager> managerMap = Maps.newHashMap();
    private static final int REDUCE_WEIGHT_FREQUENCY = 72000;
    @Deprecated
    public static final String WAYPOINT_FILE_NAME_OLD = "ayaka_waypoints.json";
    public static final String WAYPOINT_FILE_NAME = "ayaka_addresses.json";
    @Deprecated
    private final Path waypointStoragePathOld;
    private final Path waypointStoragePath;
    private final Map<String, Address> addressMap = Maps.newHashMap();
    public final MinecraftServer mcServer;

    @Deprecated
    private static Collection<AddressOld> loadFromPathOld(Path storagePath) throws IOException {
        Collection addresses = (Collection)CarpetAyakaAddition.GSON.fromJson(FileUtils.readFile(storagePath), COLLECTION_TYPE_OLD);
        return addresses == null ? Collections.emptyList() : addresses;
    }

    private static Map<String, Address> loadFromPath(Path storagePath) throws IOException {
        Map addresses = (Map)CarpetAyakaAddition.GSON.fromJson(FileUtils.readFile(storagePath), MAP_TYPE);
        return addresses == null ? Collections.emptyMap() : addresses;
    }

    public static AddressManager getOrCreate(MinecraftServer server) {
        return managerMap.computeIfAbsent(server, AddressManager::new);
    }

    public static void removeWaypointManager(MinecraftServer server) {
        AddressManager manager = managerMap.remove(server);
        if (manager == null) {
            return;
        }
        try {
            manager.save();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
        }
    }

    private AddressManager(MinecraftServer server) {
        this.mcServer = server;
        this.waypointStoragePath = server.method_3847(class_2874.field_13072).method_17982().method_132().toPath().resolve(WAYPOINT_FILE_NAME);
        this.waypointStoragePathOld = server.method_3847(class_2874.field_13072).method_17982().method_132().toPath().resolve(WAYPOINT_FILE_NAME_OLD);
        try {
            this.load();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to load addresses", (Throwable)e);
        }
        CarpetAyakaServer.INSTANCE.addTickTask(it -> new ReduceWeightTask((CarpetAyakaServer)it, this));
    }

    @Contract(mutates="this")
    private void put(AddressOld addressOld) {
        this.put(AbstractAddress.fromOld(addressOld));
    }

    @Contract(mutates="this")
    private Address put(Address address) {
        CarpetAyakaAddition.LOGGER.debug("Put address {}", (Object)address);
        return this.addressMap.put(address.getId(), address);
    }

    @Contract(mutates="this, io")
    public void load() throws IOException {
        this.addressMap.clear();
        if (Files.isRegularFile(this.waypointStoragePathOld, new LinkOption[0])) {
            CarpetAyakaAddition.LOGGER.warn("Loading addresses from {} which is deprecated", (Object)this.waypointStoragePathOld);
            AddressManager.loadFromPathOld(this.waypointStoragePathOld).forEach(this::put);
            Files.delete(this.waypointStoragePathOld);
        }
        if (Files.isRegularFile(this.waypointStoragePath, new LinkOption[0])) {
            CarpetAyakaAddition.LOGGER.debug("Loading addresses from {}", (Object)this.waypointStoragePath);
            try {
                this.addressMap.putAll(AddressManager.loadFromPath(this.waypointStoragePath));
            }
            catch (JsonSyntaxException e) {
                CarpetAyakaAddition.LOGGER.warn("Loading addresses from {} with old form which is deprecated", (Object)this.waypointStoragePath);
                AddressManager.loadFromPathOld(this.waypointStoragePath).forEach(this::put);
            }
        }
        this.save();
    }

    @Contract(mutates="io")
    public void save() throws IOException {
        CarpetAyakaAddition.LOGGER.debug("Saving addresses to {}", (Object)this.waypointStoragePath);
        Files.write(this.waypointStoragePath, CarpetAyakaAddition.GSON.toJson(this.addressMap, MAP_TYPE).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Contract(pure=true)
    public Address get(String id) {
        return this.addressMap.get(id);
    }

    @Contract(pure=true)
    public Set<String> getIDs() {
        return this.addressMap.keySet();
    }

    @Contract(pure=true)
    public Collection<Address> getAddresses() {
        return this.addressMap.values();
    }

    @Contract(mutates="this, io")
    public Address rename(String oldId, String newId) throws IOException {
        Address w = this.addressMap.remove(oldId);
        if (w == null) {
            return null;
        }
        Address a = new Address(newId, w.getDim(), w.getPos(), w.getDesc(), w.getWeight());
        if (this.put(a) != null) {
            CarpetAyakaAddition.LOGGER.warn("Address named {} already exists", (Object)newId);
        }
        CarpetAyakaAddition.LOGGER.debug("Renaming {} to {}", (Object)w, (Object)a);
        this.save();
        return w;
    }

    @Contract(mutates="this, io")
    public Address remove(String id) throws IOException {
        Address w = this.addressMap.remove(id);
        CarpetAyakaAddition.LOGGER.debug("Removed address {}", (Object)w);
        this.save();
        return w;
    }

    @Contract(mutates="this, io")
    public Address set(Address address) throws IOException {
        Address w = this.put(address);
        CarpetAyakaAddition.LOGGER.debug("Set address {}", (Object)address);
        this.save();
        return w;
    }

    private static class ReduceWeightTask
    extends TickTask.FrequentTask {
        private final AddressManager manager;

        public ReduceWeightTask(CarpetAyakaServer modServer, AddressManager manager) {
            super(modServer, 72000);
            if (manager.mcServer != modServer.mcServer) {
                throw new IllegalArgumentException("Mismatched Minecraft server");
            }
            this.manager = manager;
        }

        @Override
        public void run() {
            this.manager.addressMap.values().forEach(AbstractAddress::reduceWeight);
        }
    }
}

