/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.settings;

import carpet.settings.ParsedRule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import com.ayakacraft.carpetayakaaddition.mixin.settings.ParsedRuleAccessor;
import com.ayakacraft.carpetayakaaddition.settings.Rule;
import com.ayakacraft.carpetayakaaddition.utils.translation.AyakaLanguage;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class AyakaRule
implements carpet.settings.Rule {
    public static final Translator RULE_TR = Translator.CARPET.resolve("rule");
    private final Field field;
    private final String name;
    private final Rule rule;
    private final SettingsManager settingsManager;
    private final Translator tr;

    public AyakaRule(Field field, SettingsManager settingsManager) {
        this.field = field;
        this.name = field.getName();
        this.rule = field.getAnnotation(Rule.class);
        this.settingsManager = settingsManager;
        this.tr = RULE_TR.resolve(this.name);
    }

    public String name() {
        return this.name;
    }

    public String desc() {
        return this.tr.translate(AyakaLanguage.getServerLanguage(), "desc");
    }

    public String[] extra() {
        String x;
        AyakaLanguage serverLang = AyakaLanguage.getServerLanguage();
        LinkedList<String> extras = new LinkedList<String>();
        int i = 0;
        while ((x = this.tr.translateWithoutFallback(serverLang, "extra." + i)) != null) {
            extras.add(x);
            ++i;
        }
        return extras.toArray(new String[0]);
    }

    public String[] category() {
        return this.rule.categories();
    }

    public String[] options() {
        return this.rule.options();
    }

    public boolean strict() {
        return this.rule.strict();
    }

    public Class<? extends Validator>[] validate() {
        return this.rule.validators();
    }

    public Class<? extends Annotation> annotationType() {
        return carpet.settings.Rule.class;
    }

    public ParsedRule<?> constructCarpetRule() {
        ParsedRule<?> parsedRule;
        try {
            parsedRule = ParsedRuleAccessor.invokeConstructor(this.field, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return parsedRule;
    }
}

