/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils.translation;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.utils.FileUtils;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public abstract class AyakaLanguage {
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Map<String, AyakaLanguage> languageMap = Maps.newHashMap();
    private static final String ASSETS = "assets/carpet-ayaka-addition/";
    private static final String LANG_META = "assets/carpet-ayaka-addition/meta/languages.json";
    public static final String DEFAULT_LANG = "en_us";
    private static boolean loaded = false;
    private final String code;

    public static void loadLanguages() {
        block4: {
            if (loaded) {
                return;
            }
            try {
                for (String lang : (String[])CarpetAyakaAddition.GSON.fromJson(FileUtils.readResource(LANG_META), String[].class)) {
                    lang = lang.toLowerCase(Locale.ROOT);
                    languageMap.put(lang, new AyakaLanguageImpl(lang));
                }
                loaded = true;
            }
            catch (Exception e) {
                CarpetAyakaAddition.LOGGER.error("Failed to load language list", (Throwable)e);
                if (!FabricLoader.getInstance().isDevelopmentEnvironment()) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public static AyakaLanguage get(String lang) {
        return languageMap.computeIfAbsent(lang.toLowerCase(Locale.ROOT), AyakaLanguageEmpty::new);
    }

    public static AyakaLanguage getDefaultLanguage() {
        return languageMap.get(DEFAULT_LANG);
    }

    public static AyakaLanguage getServerLanguage() {
        return AyakaLanguage.get(DEFAULT_LANG);
    }

    protected AyakaLanguage(String lang) {
        this.code = lang.toLowerCase(Locale.ROOT);
    }

    public String code() {
        return this.code;
    }

    public abstract Map<String, String> translations();

    public String translate(String key) {
        String s = this.translateWithoutFallback(key);
        if (s != null) {
            return s;
        }
        if (DEFAULT_LANG.equals(this.code)) {
            return key;
        }
        return AyakaLanguage.getDefaultLanguage().translate(key);
    }

    public String translateWithoutFallback(String key) {
        return this.translations().get(key);
    }

    private static class AyakaLanguageImpl
    extends AyakaLanguage {
        private final Map<String, String> translations;

        private AyakaLanguageImpl(String code) {
            super(code);
            Map tr = Collections.emptyMap();
            try {
                String data = FileUtils.readResource(String.format("assets/carpet-ayaka-addition/lang/%s.json", this.code()));
                Map map = (Map)CarpetAyakaAddition.GSON.fromJson(data, MAP_TYPE);
                if (map != null) {
                    tr = Collections.unmodifiableMap(map);
                }
            }
            catch (Exception e) {
                CarpetAyakaAddition.LOGGER.error("Failed to load language {}", (Object)this.code(), (Object)e);
            }
            this.translations = tr;
        }

        @Override
        public Map<String, String> translations() {
            return this.translations;
        }
    }

    private static class AyakaLanguageEmpty
    extends AyakaLanguage {
        public AyakaLanguageEmpty(String code) {
            super(code);
        }

        @Override
        public Map<String, String> translations() {
            return Collections.emptyMap();
        }
    }
}

