/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.mixin.logging;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.logging.AyakaExtensionLogger;
import com.ayakacraft.carpetayakaaddition.logging.AyakaLoggerRegistry;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(require={@Condition(value="minecraft", versionPredicates={"<1.15"})})
@Mixin(value={LoggerRegistry.class}, remap=false)
public abstract class LoggerRegistryMixin {
    @Inject(method={"initLoggers"}, at={@At(value="RETURN")})
    private static void registerToCarpet(CallbackInfo ci) {
        AyakaLoggerRegistry.ayakaLoggers.forEach(it -> LoggerRegistryMixin.registerLogger(it.getLogName(), it));
    }

    @WrapMethod(method={"setAccess"})
    private static void onSetAccess(Logger logger, Operation<Void> original) {
        if (logger instanceof AyakaExtensionLogger) {
            try {
                ((AyakaExtensionLogger)logger).getField().setBoolean(null, logger.hasOnlineSubscribers());
            }
            catch (IllegalAccessException e) {
                CarpetAyakaAddition.LOGGER.warn("Cannot change logger quick access field, logger might be disabled", (Throwable)e);
            }
        } else {
            original.call(new Object[]{logger});
        }
    }

    @Shadow
    public static void registerLogger(String name, Logger logger) {
    }
}

