/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.utils;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaServer;
import net.minecraft.server.MinecraftServer;

public abstract class TickTask {
    protected final CarpetAyakaServer modServer;
    protected final MinecraftServer mcServer;
    private boolean finished;
    private boolean cancelled;

    public TickTask(CarpetAyakaServer modServer) {
        this.modServer = modServer;
        this.mcServer = modServer.mcServer;
    }

    protected void finish() {
        this.finished = true;
    }

    public void start() {
    }

    public void cancel() {
        this.cancelled = true;
    }

    public abstract void tick();

    public boolean isFinished() {
        return this.finished || this.cancelled;
    }

    public static class RunPerTickTask
    extends TickTask {
        private static final Runnable EMPTY_TASK = () -> {};
        private final Runnable task;
        private final boolean runOnCancel;

        public RunPerTickTask(CarpetAyakaServer modServer, Runnable task, boolean runOnCancel) {
            super(modServer);
            this.task = task == null ? EMPTY_TASK : task;
            this.runOnCancel = runOnCancel;
        }

        @Override
        public void cancel() {
            if (this.runOnCancel) {
                this.task.run();
            }
            super.cancel();
        }

        @Override
        public void tick() {
            this.task.run();
        }
    }

    public static abstract class FrequentTask
    extends TickTask
    implements Runnable {
        private final int frequency;

        public FrequentTask(CarpetAyakaServer modServer, int frequency) {
            super(modServer);
            this.frequency = frequency;
        }

        @Override
        public void tick() {
            if (this.mcServer.method_3780() % this.frequency == 0) {
                this.run();
            }
        }
    }

    public static abstract class CountDownTask
    extends TickTask
    implements Runnable {
        private final int endTick;

        public CountDownTask(CarpetAyakaServer modServer, int ticksToCount) {
            super(modServer);
            this.endTick = this.mcServer.method_3780() + ticksToCount;
        }

        @Override
        public void tick() {
            if (this.mcServer.method_3780() >= this.endTick) {
                this.run();
                this.finish();
            }
        }
    }
}

