/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.killitem;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaServer;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaSettings;
import com.ayakacraft.carpetayakaaddition.commands.AyakaCommandRegistry;
import com.ayakacraft.carpetayakaaddition.utils.CommandUtils;
import com.ayakacraft.carpetayakaaddition.utils.EntityUtils;
import com.ayakacraft.carpetayakaaddition.utils.TickTask;
import com.ayakacraft.carpetayakaaddition.utils.text.TextUtils;
import com.ayakacraft.carpetayakaaddition.utils.translation.Translator;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedList;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class KillItemCommand {
    public static final String NAME = "killitem";
    public static final Translator TR = AyakaCommandRegistry.COMMAND_TR.resolve("killitem");

    private static int killItem(CommandContext<class_2168> context) {
        if (CarpetAyakaSettings.killItemAwaitSeconds == 0) {
            return KillItemCommand.killItem0((class_2168)context.getSource());
        }
        CarpetAyakaServer.INSTANCE.addTickTask(it -> new KillItemTickTask((CarpetAyakaServer)it, CarpetAyakaSettings.killItemAwaitSeconds, (class_2168)context.getSource()));
        return 1;
    }

    private static int killItem0(class_2168 source) {
        LinkedList targets = Lists.newLinkedList();
        MinecraftServer server = source.method_9211();
        server.method_3738().forEach(world -> targets.addAll(world.method_18198(class_1299.field_6052, itemEntity -> true)));
        if (targets.isEmpty()) {
            TextUtils.broadcastTranslatable(server, false, TR.resolve("none"), new Object[0]);
            return 0;
        }
        targets.forEach(EntityUtils::kill);
        if (targets.size() == 1) {
            TextUtils.broadcastTranslatable(server, false, TR.resolve("single"), ((class_1297)targets.get(0)).method_5476());
        } else {
            TextUtils.broadcastTranslatable(server, false, TR.resolve("multiple"), targets.size());
        }
        return targets.size();
    }

    private static int cancel(CommandContext<class_2168> context) {
        int i = CarpetAyakaServer.INSTANCE.cancelTickTasksMatching(tickTask -> tickTask instanceof KillItemTickTask);
        class_2168 source = (class_2168)context.getSource();
        if (i == 0) {
            TextUtils.broadcastTranslatable(source.method_9211(), false, TR.resolve("cancel.none"), new Object[0]);
        } else if (i == 1) {
            TextUtils.broadcastTranslatable(source.method_9211(), false, TR.resolve("cancel.single"), new Object[0]);
        } else {
            TextUtils.broadcastTranslatable(source.method_9211(), false, TR.resolve("cancel.multiple"), i);
        }
        return i;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(source -> CommandUtils.checkPermission(source, CarpetAyakaSettings.commandKillItem, false))).executes(KillItemCommand::killItem)).then(class_2170.method_9247((String)"cancel").executes(KillItemCommand::cancel)));
    }

    private static class KillItemTickTask
    extends TickTask.CountDownTask {
        private final int awaitSeconds;
        private final class_2168 source;

        public KillItemTickTask(CarpetAyakaServer modServer, int awaitSeconds, class_2168 source) {
            super(modServer, awaitSeconds * 20);
            this.awaitSeconds = awaitSeconds;
            this.source = source;
        }

        @Override
        public void start() {
            TextUtils.broadcast(this.mcServer, (class_2561)TextUtils.joinObj(TR.tr("task.start.0", this.awaitSeconds).method_10854(class_124.field_1065), " ", TextUtils.withCommand(TR.tr("task.start.1", new Object[0]), "/killitem cancel")), p -> TextUtils.joinObj(TR.tr((class_3222)p, "task.start.0", (Object)this.awaitSeconds).method_10854(class_124.field_1065), " ", TextUtils.withCommand(TR.tr((class_3222)p, "task.start.1", new Object[0]), "/killitem cancel")), false);
        }

        @Override
        public void run() {
            KillItemCommand.killItem0(this.source);
        }
    }
}

