/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import com.ayakacraft.carpetayakaaddition.CarpetAyakaServer;
import com.ayakacraft.carpetayakaaddition.utils.mods.ModUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CarpetAyakaAddition
implements ModInitializer {
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>(2);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    public static final String MOD_ID = "carpet-ayaka-addition";
    public static final String MOD_NAME;
    public static final Logger LOGGER;
    public static final String MOD_VERSION;

    public static Map<String, String> canHasTranslations(String lang) {
        if (translations.containsKey(lang)) {
            return translations.get(lang);
        }
        Map translation = Collections.emptyMap();
        InputStream langStream = CarpetAyakaServer.class.getClassLoader().getResourceAsStream(String.format("assets/carpet-ayaka-addition/lang/%s.json", lang));
        if (langStream != null) {
            try {
                byte[] data = new byte[langStream.available()];
                int i = langStream.read(data);
                if (i != data.length) {
                    data = Arrays.copyOf(data, i);
                }
                String jsonData = new String(data, StandardCharsets.UTF_8);
                langStream.close();
                translation = (Map)GSON.fromJson(jsonData, MAP_TYPE);
                translations.put(lang, translation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return translation;
    }

    public void onInitialize() {
        LOGGER.debug("Initializing {} Version {}", (Object)MOD_NAME, (Object)MOD_VERSION);
        CarpetServer.manageExtension((CarpetExtension)CarpetAyakaServer.INSTANCE);
    }

    static {
        Optional<ModContainer> o = ModUtils.getModContainer(MOD_ID);
        if (o.isPresent()) {
            MOD_NAME = o.get().getMetadata().getName();
            MOD_VERSION = o.get().getMetadata().getVersion().toString();
        } else {
            MOD_NAME = "Carpet Ayaka Addition";
            MOD_VERSION = "dev";
        }
        LOGGER = LogManager.getLogger((String)MOD_NAME);
    }
}

