/*
 * Decompiled with CFR 0.152.
 */
package com.ayakacraft.carpetayakaaddition.commands.address;

import com.ayakacraft.carpetayakaaddition.CarpetAyakaAddition;
import com.ayakacraft.carpetayakaaddition.commands.address.Address;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class AddressManager {
    private static final Type COLLECTION_TYPE = new TypeToken<Collection<Address>>(){}.getType();
    private static final HashMap<MinecraftServer, AddressManager> managerMap = new HashMap(1);
    @Deprecated
    public static final String WAYPOINT_FILE_NAME_OLD = "ayaka_waypoints.json";
    public static final String WAYPOINT_FILE_NAME = "ayaka_addresses.json";
    @Deprecated
    private final Path waypointStoragePathOld;
    private final Path waypointStoragePath;
    private final LinkedHashMap<String, Address> addressMap = new LinkedHashMap(3);

    private static Collection<Address> loadFromPath(Path storagePath) throws IOException {
        String str = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(Files.readAllBytes(storagePath))).toString();
        Collection addresses = (Collection)CarpetAyakaAddition.GSON.fromJson(str, COLLECTION_TYPE);
        return addresses == null ? Collections.emptyList() : addresses;
    }

    public static AddressManager getOrCreate(MinecraftServer server) {
        if (managerMap.containsKey(server)) {
            return managerMap.get(server);
        }
        AddressManager instance = new AddressManager(server);
        managerMap.put(server, instance);
        return instance;
    }

    public static void removeWaypointManager(MinecraftServer server) {
        if (!managerMap.containsKey(server)) {
            return;
        }
        try {
            managerMap.remove(server).save();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to save addresses", (Throwable)e);
        }
    }

    private AddressManager(MinecraftServer server) {
        this.waypointStoragePath = server.method_27050(class_5218.field_24188).resolve(WAYPOINT_FILE_NAME);
        this.waypointStoragePathOld = server.method_27050(class_5218.field_24188).resolve(WAYPOINT_FILE_NAME_OLD);
        try {
            this.load();
        }
        catch (IOException e) {
            CarpetAyakaAddition.LOGGER.error("Failed to load addresses", (Throwable)e);
        }
    }

    private Address put(Address address) {
        CarpetAyakaAddition.LOGGER.debug("Put address {}", (Object)address);
        return this.addressMap.put(address.getId(), address);
    }

    public void load() throws IOException {
        this.addressMap.clear();
        if (Files.isRegularFile(this.waypointStoragePathOld, new LinkOption[0])) {
            CarpetAyakaAddition.LOGGER.warn("Loading addresses from {} which is deprecated", (Object)this.waypointStoragePathOld);
            AddressManager.loadFromPath(this.waypointStoragePathOld).forEach(this::put);
            Files.delete(this.waypointStoragePathOld);
        }
        if (Files.isRegularFile(this.waypointStoragePath, new LinkOption[0])) {
            CarpetAyakaAddition.LOGGER.debug("Loading addresses from {}", (Object)this.waypointStoragePath);
            AddressManager.loadFromPath(this.waypointStoragePath).forEach(this::put);
        }
        this.save();
    }

    public void save() throws IOException {
        CarpetAyakaAddition.LOGGER.debug("Saving addresses to {}", (Object)this.waypointStoragePath);
        Files.write(this.waypointStoragePath, CarpetAyakaAddition.GSON.toJson(this.addressMap.values(), COLLECTION_TYPE).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public Address get(String id) {
        return this.addressMap.get(id);
    }

    public Set<String> getIDs() {
        return this.addressMap.keySet();
    }

    public Collection<Address> getWaypoints() {
        return this.addressMap.values();
    }

    public Address rename(String oldId, String newId) throws IOException {
        Address w = (Address)this.addressMap.remove(oldId);
        if (w == null) {
            return null;
        }
        Address a = new Address(newId, w.getDim(), w.getPos(), w.getDesc());
        if (this.put(a) != null) {
            CarpetAyakaAddition.LOGGER.warn("Address named {} already exists", (Object)newId);
        }
        CarpetAyakaAddition.LOGGER.debug("Renaming {} to {}", (Object)w, (Object)a);
        this.save();
        return w;
    }

    public Address remove(String id) throws IOException {
        Address w = (Address)this.addressMap.remove(id);
        CarpetAyakaAddition.LOGGER.debug("Removed address {}", (Object)w);
        this.save();
        return w;
    }

    public Address set(Address address) throws IOException {
        Address w = this.put(address);
        CarpetAyakaAddition.LOGGER.debug("Set address {}", (Object)address);
        this.save();
        return w;
    }
}

