/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gamecharacterstats.network;

import java.util.function.Supplier;
import net.mcreator.gamecharacterstats.GameCharacterStatsMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GameCharacterStatsModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"game_character_stats");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GameCharacterStatsMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"game_character_stats", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double ChosenCharactor = 0.0;
        public double StatLevelNiko = 0.0;
        public boolean StatLevel100AbilityEnabled = false;
        public boolean StatIcon = false;
        public double StatLevelFrisk = 0.0;
        public boolean Passive1Toggle = true;
        public boolean Passive2Toggle = true;
        public boolean dontshowagain = false;
        public boolean DebugEnabled = false;
        public boolean CSDeveloperMode = false;
        public boolean KissaEnabled = false;
        public double VanityCharacter = 0.0;
        public double CharacterSwitchEndTimer = 0.0;
        public boolean Charging = false;
        public double ChargingCooldown = 0.0;
        public double BkEarBlush = 0.0;
        public boolean TesterMode = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("ChosenCharactor", this.ChosenCharactor);
            nbt.putDouble("StatLevelNiko", this.StatLevelNiko);
            nbt.putBoolean("StatLevel100AbilityEnabled", this.StatLevel100AbilityEnabled);
            nbt.putBoolean("StatIcon", this.StatIcon);
            nbt.putDouble("StatLevelFrisk", this.StatLevelFrisk);
            nbt.putBoolean("Passive1Toggle", this.Passive1Toggle);
            nbt.putBoolean("Passive2Toggle", this.Passive2Toggle);
            nbt.putBoolean("dontshowagain", this.dontshowagain);
            nbt.putBoolean("DebugEnabled", this.DebugEnabled);
            nbt.putBoolean("CSDeveloperMode", this.CSDeveloperMode);
            nbt.putBoolean("KissaEnabled", this.KissaEnabled);
            nbt.putDouble("VanityCharacter", this.VanityCharacter);
            nbt.putDouble("CharacterSwitchEndTimer", this.CharacterSwitchEndTimer);
            nbt.putBoolean("Charging", this.Charging);
            nbt.putDouble("ChargingCooldown", this.ChargingCooldown);
            nbt.putDouble("BkEarBlush", this.BkEarBlush);
            nbt.putBoolean("TesterMode", this.TesterMode);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.ChosenCharactor = nbt.getDouble("ChosenCharactor");
            this.StatLevelNiko = nbt.getDouble("StatLevelNiko");
            this.StatLevel100AbilityEnabled = nbt.getBoolean("StatLevel100AbilityEnabled");
            this.StatIcon = nbt.getBoolean("StatIcon");
            this.StatLevelFrisk = nbt.getDouble("StatLevelFrisk");
            this.Passive1Toggle = nbt.getBoolean("Passive1Toggle");
            this.Passive2Toggle = nbt.getBoolean("Passive2Toggle");
            this.dontshowagain = nbt.getBoolean("dontshowagain");
            this.DebugEnabled = nbt.getBoolean("DebugEnabled");
            this.CSDeveloperMode = nbt.getBoolean("CSDeveloperMode");
            this.KissaEnabled = nbt.getBoolean("KissaEnabled");
            this.VanityCharacter = nbt.getDouble("VanityCharacter");
            this.CharacterSwitchEndTimer = nbt.getDouble("CharacterSwitchEndTimer");
            this.Charging = nbt.getBoolean("Charging");
            this.ChargingCooldown = nbt.getDouble("ChargingCooldown");
            this.BkEarBlush = nbt.getDouble("BkEarBlush");
            this.TesterMode = nbt.getBoolean("TesterMode");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.ChosenCharactor = original.ChosenCharactor;
            clone.StatLevelNiko = original.StatLevelNiko;
            clone.StatLevel100AbilityEnabled = original.StatLevel100AbilityEnabled;
            clone.StatIcon = original.StatIcon;
            clone.StatLevelFrisk = original.StatLevelFrisk;
            clone.Passive1Toggle = original.Passive1Toggle;
            clone.Passive2Toggle = original.Passive2Toggle;
            clone.dontshowagain = original.dontshowagain;
            clone.DebugEnabled = original.DebugEnabled;
            clone.CSDeveloperMode = original.CSDeveloperMode;
            clone.KissaEnabled = original.KissaEnabled;
            clone.VanityCharacter = original.VanityCharacter;
            clone.CharacterSwitchEndTimer = original.CharacterSwitchEndTimer;
            clone.BkEarBlush = original.BkEarBlush;
            clone.TesterMode = original.TesterMode;
            if (!event.isWasDeath()) {
                clone.Charging = original.Charging;
                clone.ChargingCooldown = original.ChargingCooldown;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

