/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gamecharacterstats.network;

import java.util.HashMap;
import net.mcreator.gamecharacterstats.GameCharacterStatsMod;
import net.mcreator.gamecharacterstats.procedures.SelectionGuiCharaProcedure;
import net.mcreator.gamecharacterstats.procedures.SelectionGuiGuestProcedure;
import net.mcreator.gamecharacterstats.procedures.SelectionGuiNikoProcedure;
import net.mcreator.gamecharacterstats.world.inventory.SelectionUiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record SelectionUiButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SelectionUiButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"game_character_stats", (String)"selection_ui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SelectionUiButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new SelectionUiButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<SelectionUiButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(SelectionUiButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                SelectionUiButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = SelectionUiMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SelectionGuiNikoProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SelectionGuiCharaProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SelectionGuiGuestProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GameCharacterStatsMod.addNetworkMessage(TYPE, STREAM_CODEC, SelectionUiButtonMessage::handleData);
    }
}

