/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.collection.listener;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivableLong2ObjectMap<V>
implements Long2ObjectMap<V> {
    private final ActiveTrigger<V>[] triggers = new ActiveTrigger[ActiveTriggerType.values().length];
    private final Long2ObjectMap<V> delegate;

    public ActivableLong2ObjectMap(Long2ObjectMap<V> delegate) {
        this.delegate = delegate;
    }

    public ActivableLong2ObjectMap<V> triggerPut(MapPutTrigger<V> putTrigger) {
        this.triggers[ActiveTriggerType.PUT.ordinal()] = putTrigger;
        return this;
    }

    public ActivableLong2ObjectMap<V> triggerRemove(MapRemoveTrigger<V> removeTrigger) {
        this.triggers[ActiveTriggerType.REMOVE.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableLong2ObjectMap<V> triggerPutAndRemoved(MapRemovedTrigger<V> removeTrigger) {
        this.triggers[ActiveTriggerType.REMOVED.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableLong2ObjectMap<V> triggerPutAndRemove(MapPutTrigger<V> putTrigger, MapRemoveTrigger<V> removeTrigger) {
        this.triggers[ActiveTriggerType.PUT.ordinal()] = putTrigger;
        this.triggers[ActiveTriggerType.REMOVE.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableLong2ObjectMap<V> triggerPutAndRemoved(MapPutTrigger<V> putTrigger, MapRemovedTrigger<V> removeTrigger) {
        this.triggers[ActiveTriggerType.PUT.ordinal()] = putTrigger;
        this.triggers[ActiveTriggerType.REMOVED.ordinal()] = removeTrigger;
        return this;
    }

    public ActivableLong2ObjectMap<V> triggerClear(MapClearTrigger<V> clearTrigger) {
        this.triggers[ActiveTriggerType.CLEAR.ordinal()] = clearTrigger;
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    @Nullable
    public V put(long key, V value) {
        ActiveTrigger<V> trigger = this.trigger(ActiveTriggerType.PUT);
        if (trigger != null) {
            trigger.trigger(key, value, this);
        }
        return (V)this.delegate.put(key, value);
    }

    public V get(long key) {
        return (V)this.delegate.get(key);
    }

    public V remove(long key) {
        ActiveTrigger<Object> removedTrigger;
        Object previousValue = this.delegate.remove(key);
        ActiveTrigger<Object> removeTrigger = this.trigger(ActiveTriggerType.REMOVE);
        if (removeTrigger != null) {
            removeTrigger.trigger(key, null, this);
        }
        if ((removedTrigger = this.trigger(ActiveTriggerType.REMOVED)) != null) {
            removedTrigger.trigger(key, previousValue, this);
        }
        return (V)previousValue;
    }

    public void putAll(@NotNull Map<? extends Long, ? extends V> m) {
        ActiveTrigger<V> trigger = this.trigger(ActiveTriggerType.PUT);
        if (trigger != null) {
            m.forEach((k, v) -> trigger.trigger((long)k, (V)v, this));
        }
        this.delegate.putAll(m);
    }

    public void clear() {
        ActiveTrigger<Object> trigger = this.trigger(ActiveTriggerType.CLEAR);
        if (trigger != null) {
            trigger.trigger(-1L, null, this);
        }
        this.delegate.clear();
    }

    public void defaultReturnValue(V rv) {
        this.delegate.defaultReturnValue(rv);
    }

    public V defaultReturnValue() {
        return (V)this.delegate.defaultReturnValue();
    }

    public ObjectSet<Long2ObjectMap.Entry<V>> long2ObjectEntrySet() {
        return this.delegate.long2ObjectEntrySet();
    }

    @NotNull
    public LongSet keySet() {
        return this.delegate.keySet();
    }

    public ObjectCollection<V> values() {
        return this.delegate.values();
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public ObjectSet<Map.Entry<Long, V>> entrySet() {
        return this.delegate.entrySet();
    }

    public ActiveTrigger<V> trigger(ActiveTriggerType type) {
        return this.triggers[type.ordinal()];
    }

    public static enum ActiveTriggerType {
        PUT,
        REMOVE,
        REMOVED,
        CLEAR;

    }

    public static interface ActiveTrigger<V> {
        public void trigger(long var1, V var3, ActivableLong2ObjectMap<V> var4);
    }

    public static interface MapClearTrigger<V>
    extends ActiveTrigger<V> {
        @Override
        default public void trigger(long k, V v, ActivableLong2ObjectMap<V> map) {
            this.trigger(map);
        }

        public void trigger(ActivableLong2ObjectMap<V> var1);
    }

    public static interface MapRemovedTrigger<V>
    extends ActiveTrigger<V> {
        @Override
        default public void trigger(long k, V v, ActivableLong2ObjectMap<V> map) {
            this.trigger(k, v);
        }

        public void trigger(long var1, V var3);
    }

    public static interface MapRemoveTrigger<V>
    extends ActiveTrigger<V> {
        @Override
        default public void trigger(long k, V v, ActivableLong2ObjectMap<V> map) {
            this.trigger(k);
        }

        public void trigger(long var1);
    }

    public static interface MapPutTrigger<V>
    extends ActiveTrigger<V> {
        @Override
        default public void trigger(long k, V v, ActivableLong2ObjectMap<V> map) {
            this.trigger(k, v);
        }

        public void trigger(long var1, V var3);
    }
}

