/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.brain.frog;

import com.github.cao.awa.sepals.entity.ai.task.SepalsLongJumpTask;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class SepalsFrogBrain {
    public static <E extends Mob> boolean shouldJumpTo(E frog, BlockPos pos) {
        boolean nodeTypeIsTrapdoor1;
        boolean posDownStateNotAir;
        Level world = frog.level();
        BlockState posState = world.getBlockState(pos);
        boolean posStateIsAir = posState.isAir();
        if (posStateIsAir) {
            return true;
        }
        BlockPos posDown = pos.below();
        BlockState posDownState = world.getBlockState(posDown);
        boolean posDownStateIsAir = posDownState.isAir();
        boolean bl = posDownStateNotAir = !posDownStateIsAir;
        if (posState.is(BlockTags.FROG_PREFER_JUMP_TO) || !posDownStateNotAir && posDownState.is(BlockTags.FROG_PREFER_JUMP_TO)) {
            return true;
        }
        if (!posState.getFluidState().isEmpty() || posDownStateNotAir && !posDownState.getFluidState().isEmpty() || !world.getFluidState(pos.above()).isEmpty()) {
            return false;
        }
        PathfindingContext pathContext = new PathfindingContext((CollisionGetter)world, frog);
        PathType nodeType = WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)pathContext, (BlockPos.MutableBlockPos)pos.mutable());
        if (SepalsLongJumpTask.shouldJumpTo(frog, posDownState, nodeType)) {
            return true;
        }
        boolean bl2 = nodeTypeIsTrapdoor1 = nodeType == PathType.TRAPDOOR;
        return posDownStateIsAir ? nodeTypeIsTrapdoor1 : nodeTypeIsTrapdoor1 || WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)pathContext, (BlockPos.MutableBlockPos)posDown.mutable()) == PathType.TRAPDOOR;
    }

    public static boolean attackable(LivingEntity entity, LivingEntity target) {
        if (SepalsFrogBrain.isHuntingCooldown(entity) || !Frog.canEat((LivingEntity)target)) {
            return false;
        }
        if (!target.closerThan((Entity)entity, 10.0)) {
            return false;
        }
        Level world = entity.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return !SepalsFrogBrain.isTargetUnreachable(entity, target) && Sensor.isEntityAttackable((ServerLevel)serverWorld, (LivingEntity)entity, (LivingEntity)target);
        }
        return false;
    }

    private static boolean isHuntingCooldown(LivingEntity entity) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN);
    }

    private static boolean isTargetUnreachable(LivingEntity entity, LivingEntity target) {
        return entity.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS).orElseGet(ArrayList::new).contains(target.getUUID());
    }
}

