/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.composite;

import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsTaskStatus;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class SepalsCompositeSingleTask<E extends LivingEntity>
implements BehaviorControl<E>,
DetailedDebuggableTask {
    private final Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState;
    private final Set<MemoryModuleType<?>> memoriesToForgetWhenStopped;
    private final BehaviorControl<? super E> task;
    private Behavior.Status status = Behavior.Status.STOPPED;

    public SepalsCompositeSingleTask(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryState, Set<MemoryModuleType<?>> memoriesToForgetWhenStopped, BehaviorControl<? super E> task) {
        this.requiredMemoryState = requiredMemoryState;
        this.memoriesToForgetWhenStopped = memoriesToForgetWhenStopped;
        this.task = task;
    }

    public Behavior.Status getStatus() {
        return this.status;
    }

    private boolean shouldStart(E entity) {
        for (Map.Entry<MemoryModuleType<?>, MemoryStatus> entry : this.requiredMemoryState.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            MemoryStatus memoryModuleState = entry.getValue();
            if (entity.getBrain().checkMemory(memoryModuleType, memoryModuleState)) continue;
            return false;
        }
        return true;
    }

    public final boolean tryStart(ServerLevel world, E entity, long time) {
        if (this.shouldStart(entity)) {
            this.status = Behavior.Status.RUNNING;
            if (SepalsTaskStatus.isStopped(this.task)) {
                this.task.tryStart(world, entity, time);
            }
            return true;
        }
        return false;
    }

    public final void tickOrStop(ServerLevel world, E entity, long time) {
        if (SepalsTaskStatus.isRunning(this.task)) {
            this.task.tickOrStop(world, entity, time);
        }
        if (SepalsTaskStatus.isStopped(this.task)) {
            this.doStop(world, entity, time);
        }
    }

    public final void doStop(ServerLevel world, E entity, long time) {
        this.status = Behavior.Status.STOPPED;
        if (SepalsTaskStatus.isRunning(this.task)) {
            this.task.doStop(world, entity, time);
        }
        this.memoriesToForgetWhenStopped.forEach(arg_0 -> ((Brain)entity.getBrain()).eraseMemory(arg_0));
    }

    public String debugString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return "(" + this.debugString() + "): " + String.valueOf(SepalsTaskStatus.isRunning(this.task) ? this.task : "[]");
    }

    @Override
    public String information() {
        BehaviorControl<? super E> behaviorControl = this.task;
        if (behaviorControl instanceof DetailedDebuggableTask) {
            DetailedDebuggableTask detailedTask = (DetailedDebuggableTask)behaviorControl;
            return detailedTask.information();
        }
        return "SingleTask(delegate=" + String.valueOf(this.task) + ")";
    }
}

