/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.iteraction;

import com.github.cao.awa.sepals.entity.ai.cache.SepalsLivingTargetCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;

public class SepalsFindInteractionTargetTask {
    public static BehaviorControl<LivingEntity> createTypedPlayer(int maxDistance) {
        double i = maxDistance * maxDistance;
        return BehaviorBuilder.create(context -> context.group((App)context.registered(MemoryModuleType.LOOK_TARGET), (App)context.absent(MemoryModuleType.INTERACTION_TARGET), (App)context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (lookTarget, interactionTarget, visibleMobs) -> (world, entity, time) -> {
            Optional<Player> optional;
            NearestVisibleLivingEntities targetCache = (NearestVisibleLivingEntities)context.get(visibleMobs);
            if (targetCache instanceof SepalsLivingTargetCache) {
                SepalsLivingTargetCache sepalsCache = (SepalsLivingTargetCache)targetCache;
                optional = sepalsCache.findFirstPlayer(target -> target.distanceToSqr((Entity)entity) <= i);
            } else {
                optional = targetCache.findClosest(target -> target.distanceToSqr((Entity)entity) <= i && EntityType.PLAYER.equals(target.getType()));
            }
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)optional.get();
            interactionTarget.set((Object)livingEntity);
            lookTarget.set((Object)new EntityTracker((Entity)livingEntity, true));
            return true;
        }));
    }
}

