/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.look;

import com.github.cao.awa.sepals.entity.ai.cache.SepalsLivingTargetCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class SepalsFindEntityTask {
    public static <E extends LivingEntity> BehaviorControl<LivingEntity> create(EntityType<? extends E> type, int maxDistance, MemoryModuleType<E> targetModule, float speed, int completionRange) {
        return SepalsFindEntityTask.create(type, maxDistance, entity -> true, entity -> true, targetModule, speed, completionRange);
    }

    public static <T extends LivingEntity, E extends LivingEntity> BehaviorControl<E> create(EntityType<? extends LivingEntity> type, int maxDistance, Predicate<E> entityPredicate, Predicate<T> targetPredicate, MemoryModuleType<T> targetModule, float speed, int completionRange) {
        float f = maxDistance * maxDistance;
        Predicate<LivingEntity> predicate = entity -> type.equals(entity.getType()) && targetPredicate.test(entity);
        return BehaviorBuilder.create(context -> context.group((App)context.registered(targetModule), (App)context.registered(MemoryModuleType.LOOK_TARGET), (App)context.absent(MemoryModuleType.WALK_TARGET), (App)context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (targetValue, lookTarget, walkTarget, visibleMobs) -> (world, entity, time) -> {
            NearestVisibleLivingEntities cache = (NearestVisibleLivingEntities)context.get(visibleMobs);
            if (entityPredicate.test(entity)) {
                Optional<LivingEntity> optional;
                if (cache instanceof SepalsLivingTargetCache) {
                    SepalsLivingTargetCache sepalsCache = (SepalsLivingTargetCache)cache;
                    optional = sepalsCache.findClosest(target -> target.distanceToSqr((Entity)entity) <= (double)f && predicate.test((LivingEntity)target));
                } else {
                    optional = cache.findClosest(target -> target.distanceToSqr((Entity)entity) <= (double)f && predicate.test((LivingEntity)target));
                }
                optional.ifPresent(target -> {
                    targetValue.set(target);
                    lookTarget.set((Object)new EntityTracker((Entity)target, true));
                    walkTarget.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), speed, completionRange));
                });
                return true;
            }
            return false;
        }));
    }
}

