/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.look;

import com.github.cao.awa.sepals.entity.ai.cache.SepalsLivingTargetCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;

public class SepalsLookAtMobWithIntervalTask {
    public static BehaviorControl<LivingEntity> frogFollow(float maxDistance, UniformInt interval) {
        double d = maxDistance * maxDistance;
        SetEntityLookTargetSometimes.Ticker interval2 = new SetEntityLookTargetSometimes.Ticker(interval);
        return BehaviorBuilder.create(context -> context.group((App)context.absent(MemoryModuleType.LOOK_TARGET), (App)context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (lookTarget, visibleMobs) -> (world, entity, time) -> {
            Optional<Player> optional;
            NearestVisibleLivingEntities cache = (NearestVisibleLivingEntities)context.get(visibleMobs);
            if (cache instanceof SepalsLivingTargetCache) {
                SepalsLivingTargetCache sepalsCache = (SepalsLivingTargetCache)cache;
                optional = sepalsCache.findFirstPlayer(e -> e.distanceToSqr((Entity)entity) <= d);
            } else {
                optional = cache.findClosest(e -> e.isAlwaysTicking() && e.distanceToSqr((Entity)entity) <= d);
            }
            if (optional.isEmpty() || !interval2.tickDownAndCheck(world.random)) {
                return false;
            }
            lookTarget.set((Object)new EntityTracker((Entity)optional.get(), true));
            return true;
        }));
    }
}

