/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.poi;

import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public class SepalsFindPointOfInterestTask {
    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> poiPredicate, MemoryModuleType<GlobalPos> poiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus, BiPredicate<ServerLevel, BlockPos> worldPosBiPredicate) {
        return SepalsFindPointOfInterestTask.create(poiPredicate, poiPosModule, poiPosModule, onlyRunIfChild, entityStatus, worldPosBiPredicate);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> poiPredicate, MemoryModuleType<GlobalPos> poiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus) {
        return SepalsFindPointOfInterestTask.create(poiPredicate, poiPosModule, poiPosModule, onlyRunIfChild, entityStatus, (world, pos) -> true);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> poiPredicate, MemoryModuleType<GlobalPos> poiPosModule, MemoryModuleType<GlobalPos> potentialPoiPosModule, boolean onlyRunIfChild, Optional<Byte> entityStatus, BiPredicate<ServerLevel, BlockPos> worldPosBiPredicate) {
        MutableLong mutableLong = new MutableLong(0L);
        Long2ObjectOpenHashMap retryMarkers = new Long2ObjectOpenHashMap();
        OneShot singleTickTask = BehaviorBuilder.create(arg_0 -> SepalsFindPointOfInterestTask.lambda$create$9(potentialPoiPosModule, onlyRunIfChild, mutableLong, (Long2ObjectMap)retryMarkers, poiPredicate, entityStatus, arg_0));
        return potentialPoiPosModule == poiPosModule ? singleTickTask : BehaviorBuilder.create(context -> context.group((App)context.absent(poiPosModule)).apply((Applicative)context, poiPos -> singleTickTask));
    }

    @Nullable
    public static Path findPathToPoi(Mob entity, Pair<Holder<PoiType>, BlockPos>[] pois) {
        if (pois.length == 0) {
            return null;
        }
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int i = 1;
        for (Pair<Holder<PoiType>, BlockPos> pair : pois) {
            i = Math.max(i, ((PoiType)((Holder)pair.getFirst()).value()).validRange());
            set.add((BlockPos)pair.getSecond());
        }
        return entity.getNavigation().createPath(set, i);
    }

    private static /* synthetic */ App lambda$create$9(MemoryModuleType potentialPoiPosModule, boolean onlyRunIfChild, MutableLong mutableLong, Long2ObjectMap retryMarkers, Predicate poiPredicate, Optional entityStatus, BehaviorBuilder.Instance taskContext) {
        return taskContext.group((App)taskContext.absent(potentialPoiPosModule)).apply((Applicative)taskContext, queryResult -> (world, entity, time) -> {
            if (onlyRunIfChild && entity.isBaby()) {
                return false;
            }
            if (mutableLong.getValue() == 0L) {
                mutableLong.setValue(world.getGameTime() + (long)world.random.nextInt(20));
                return false;
            }
            if (world.getGameTime() < mutableLong.getValue()) {
                return false;
            }
            mutableLong.setValue(time + 20L + (long)world.getRandom().nextInt(20));
            PoiManager pointOfInterestStorage = world.getPoiManager();
            retryMarkers.long2ObjectEntrySet().removeIf(entry -> !((RetryMarker)entry.getValue()).isAttempting(time));
            Predicate<BlockPos> predicate2 = pos -> {
                RetryMarker retryMarker = (RetryMarker)retryMarkers.get(pos.asLong());
                if (retryMarker == null) {
                    return true;
                }
                if (!retryMarker.shouldRetry(time)) {
                    return false;
                }
                retryMarker.setAttemptTime(time);
                return true;
            };
            Pair[] poiPoses = (Pair[])SepalsPointOfInterestStorage.getSortedTypesAndPositions(pointOfInterestStorage, poiPredicate, predicate2, entity.blockPosition(), 48, PoiManager.Occupancy.HAS_SPACE).holdTill(5).distinct().safeArray();
            Path path = SepalsFindPointOfInterestTask.findPathToPoi((Mob)entity, poiPoses);
            if (path == null || !path.canReach()) {
                for (Pair pair : poiPoses) {
                    retryMarkers.computeIfAbsent(((BlockPos)pair.getSecond()).asLong(), x -> new RetryMarker(world.random, time));
                }
            } else {
                BlockPos blockPos = path.getTarget();
                pointOfInterestStorage.getType(blockPos).ifPresent(poiType -> {
                    SepalsPointOfInterestStorage.getPosition(pointOfInterestStorage, poiPredicate, (registryEntry, blockPos2) -> blockPos2.equals((Object)blockPos), blockPos, 1);
                    queryResult.set((Object)GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)blockPos));
                    entityStatus.ifPresent(status -> world.broadcastEntityEvent((Entity)entity, status.byteValue()));
                    retryMarkers.clear();
                    world.debugSynchronizers().updatePoi(blockPos);
                });
            }
            return true;
        });
    }

    static class RetryMarker {
        private final RandomSource random;
        private long previousAttemptAt;
        private long nextScheduledAttemptAt;
        private int currentDelay;

        RetryMarker(RandomSource random, long time) {
            this.random = random;
            this.setAttemptTime(time);
        }

        public void setAttemptTime(long time) {
            this.previousAttemptAt = time;
            int i = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(i, 400);
            this.nextScheduledAttemptAt = time + (long)this.currentDelay;
        }

        public boolean isAttempting(long time) {
            return time - this.previousAttemptAt < 400L;
        }

        public boolean shouldRetry(long time) {
            return time >= this.nextScheduledAttemptAt;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptAt + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptAt + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

