/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.rest.sleep;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SepalsSleepTask
extends Behavior<LivingEntity> {
    private long startTime;

    public SepalsSleepTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.LAST_WOKEN, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean checkExtraStartConditions(ServerLevel world, LivingEntity entity) {
        long l;
        if (entity.isPassenger()) {
            return false;
        }
        Brain brain = entity.getBrain();
        GlobalPos globalPos = (GlobalPos)brain.getMemory(MemoryModuleType.HOME).get();
        if (world.dimension() != globalPos.dimension()) {
            return false;
        }
        Optional optional = brain.getMemory(MemoryModuleType.LAST_WOKEN);
        if (optional.isPresent() && (l = world.getGameTime() - (Long)optional.get()) > 0L && l < 100L) {
            return false;
        }
        BlockState blockState = world.getBlockState(globalPos.pos());
        return globalPos.pos().closerToCenterThan((Position)entity.position(), 2.0) && blockState.is(BlockTags.BEDS) && (Boolean)blockState.getValue((Property)BedBlock.OCCUPIED) == false;
    }

    protected boolean canStillUse(ServerLevel world, LivingEntity entity, long time) {
        Optional optional = entity.getBrain().getMemory(MemoryModuleType.HOME);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockPos = ((GlobalPos)optional.get()).pos();
        return entity.getBrain().isActive(Activity.REST) && entity.getY() > (double)blockPos.getY() + 0.4 && blockPos.closerToCenterThan((Position)entity.position(), 1.14);
    }

    protected void start(ServerLevel world, LivingEntity entity, long time) {
        if (time > this.startTime) {
            Brain brain = entity.getBrain();
            if (brain.hasMemoryValue(MemoryModuleType.DOORS_TO_CLOSE)) {
                Set set = (Set)brain.getMemory(MemoryModuleType.DOORS_TO_CLOSE).get();
                Optional optional = brain.hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES) ? brain.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES) : Optional.empty();
                InteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough((ServerLevel)world, (LivingEntity)entity, null, null, (Set)set, (Optional)optional);
            }
            entity.startSleeping(((GlobalPos)entity.getBrain().getMemory(MemoryModuleType.HOME).get()).pos());
        }
    }

    protected boolean timedOut(long time) {
        return false;
    }

    protected void stop(ServerLevel world, LivingEntity entity, long time) {
        if (entity.isSleeping()) {
            entity.stopSleeping();
            this.startTime = time + 40L;
        }
    }
}

