/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.wait;

import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsTaskStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;

public class SepalsWaitTask
implements BehaviorControl<LivingEntity>,
DetailedDebuggableTask {
    private final int minRunTime;
    private final int maxRunTime;
    private Behavior.Status status = Behavior.Status.STOPPED;
    @VisibleForDebug
    private long currentTime;
    private long waitUntil;

    public SepalsWaitTask(int minRunTime, int maxRunTime) {
        this.minRunTime = minRunTime;
        this.maxRunTime = maxRunTime;
    }

    public Behavior.Status getStatus() {
        return this.status;
    }

    public final boolean tryStart(ServerLevel world, LivingEntity entity, long time) {
        this.status = Behavior.Status.RUNNING;
        int i = this.minRunTime + world.getRandom().nextInt(this.maxRunTime + 1 - this.minRunTime);
        this.waitUntil = time + (long)i;
        return true;
    }

    public final void tickOrStop(ServerLevel world, LivingEntity entity, long time) {
        this.currentTime = time;
        if (time > this.waitUntil) {
            this.doStop(world, entity, time);
        }
    }

    public final void doStop(ServerLevel world, LivingEntity entity, long time) {
        this.status = Behavior.Status.STOPPED;
    }

    public String debugString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String information() {
        if (SepalsTaskStatus.isStopped(this)) {
            return "WaitTask(STOPPED, runTime(max=" + this.maxRunTime + ", min=" + this.minRunTime + "))";
        }
        return "WaitTask(RUNNING, runTime(max=" + this.maxRunTime + ", min=" + this.minRunTime + ", remaining=" + (this.waitUntil - this.currentTime) + "))";
    }
}

