/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.walk;

import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import com.github.cao.awa.sepals.entity.ai.task.SepalsSingleTickTask;
import com.github.cao.awa.sepals.entity.ai.task.poi.SepalsFindPointOfInterestTask;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestStorage;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class SepalsWalkHomeTask
extends SepalsSingleTickTask<PathfinderMob>
implements DetailedDebuggableTask {
    private final float speed;
    private final Long2LongMap walkedPoses = new Long2LongOpenHashMap();
    private final MutableLong nextWalkTime = new MutableLong(0L);

    public SepalsWalkHomeTask(float speed) {
        this.speed = speed;
    }

    public static SepalsWalkHomeTask create(float speed) {
        return new SepalsWalkHomeTask(speed);
    }

    @Override
    public boolean complete(ServerLevel world, PathfinderMob entity, long time) {
        if (world.getGameTime() - this.nextWalkTime.getValue() < 20L) {
            return false;
        }
        PoiManager pointOfInterestStorage = world.getPoiManager();
        Optional<BlockPos> optional = SepalsPointOfInterestStorage.getNearestPosition(pointOfInterestStorage, poiType -> poiType.is(PoiTypes.HOME), entity.blockPosition(), 48, PoiManager.Occupancy.ANY);
        if (optional.isPresent() && optional.get().distSqr((Vec3i)entity.blockPosition()) > 4.0) {
            MutableInt limiter = new MutableInt(0);
            this.nextWalkTime.setValue(world.getGameTime() + (long)world.getRandom().nextInt(20));
            Predicate<BlockPos> predicate = pos -> {
                long l = pos.asLong();
                if (this.walkedPoses.containsKey(l)) {
                    return false;
                }
                if (limiter.incrementAndGet() >= 5) {
                    return false;
                }
                this.walkedPoses.put(l, this.nextWalkTime.getValue() + 40L);
                return true;
            };
            Pair[] set = (Pair[])SepalsPointOfInterestStorage.getTypesAndPositions(pointOfInterestStorage, poiType -> poiType.is(PoiTypes.HOME), predicate, entity.blockPosition(), 48, PoiManager.Occupancy.ANY).safeArray();
            Path path = SepalsFindPointOfInterestTask.findPathToPoi((Mob)entity, set);
            if (path == null || !path.canReach()) {
                if (limiter.getValue() < 5) {
                    this.walkedPoses.long2LongEntrySet().removeIf(entry -> entry.getLongValue() < this.nextWalkTime.getValue());
                }
            } else {
                BlockPos blockPos = path.getTarget();
                Optional optional2 = pointOfInterestStorage.getType(blockPos);
                if (optional2.isPresent()) {
                    this.remember(MemoryModuleType.WALK_TARGET, new WalkTarget(blockPos, this.speed, 1));
                    world.debugSynchronizers().updatePoi(blockPos);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String information() {
        return "WalkHomeTask(nextWalk(waiting=" + (this.nextWalkTime.getValue() - this.currentTime()) + "), walked" + Arrays.toString(this.walkedPoses.values().longStream().toArray()) + ")";
    }
}

