/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.intersects;

import com.github.cao.awa.sepals.mixin.world.WorldAccessor;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SepalsWorldEntityIntersects {
    private int crammingCount = 0;

    public void quickInterestOtherEntities(Level world, @Nullable Entity except, AABB box, Predicate<? super Entity> predicate, Consumer<Entity> action) {
        this.crammingCount = 0;
        ArrayList entities = CollectionFactor.arrayList();
        ((WorldAccessor)world).invokeGetEntityLookup().get(box, entity -> {
            if (entity == except) {
                return;
            }
            entities.add(entity);
        });
        for (Entity entity2 : entities) {
            if (!predicate.test((Entity)entity2)) continue;
            action.accept(entity2);
        }
        for (EnderDragonPart enderDragonPart : world.dragonParts()) {
            if (enderDragonPart == except || enderDragonPart.parentMob == except || !predicate.test((Entity)enderDragonPart) || !box.intersects(enderDragonPart.getBoundingBox())) continue;
            action.accept((Entity)enderDragonPart);
        }
    }

    public void quickInterestOtherEntities(Level world, @Nullable Entity except, AABB box, Predicate<? super Entity> predicate, Consumer<Entity> action, Consumer<Entity> crammingAction, int crammingLimit) {
        this.crammingCount = 0;
        ArrayList entities = CollectionFactor.arrayList();
        ((WorldAccessor)world).invokeGetEntityLookup().get(box, entity -> {
            if (entity == except) {
                return;
            }
            entities.add(entity);
        });
        for (Entity entity2 : entities) {
            if (!predicate.test((Entity)entity2)) continue;
            this.tryDoEntityInterest(entity2, action, crammingAction, crammingLimit);
        }
        for (EnderDragonPart enderDragonPart : world.dragonParts()) {
            if (enderDragonPart == except || enderDragonPart.parentMob == except || !predicate.test((Entity)enderDragonPart) || !box.intersects(enderDragonPart.getBoundingBox())) continue;
            this.tryDoEntityInterest((Entity)enderDragonPart, action, crammingAction, crammingLimit);
        }
    }

    private void tryDoEntityInterest(@NotNull Entity entity, Consumer<Entity> action, Consumer<Entity> crammingAction, int crammingLimit) {
        if (!entity.isPassenger()) {
            ++this.crammingCount;
        }
        action.accept(entity);
        if (this.crammingCount > crammingLimit) {
            action.accept(entity);
        }
    }
}

