/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.entity.intersects.SepalsWorldEntityIntersects;
import com.github.cao.awa.sepals.entity.predicate.SepalsEntityPredicates;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected abstract void doPush(Entity var1);

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"pushEntities()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void sepalsCramming(CallbackInfo ci) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (Sepals.CONFIG.isEnableSepalsEntitiesCramming()) {
                int maxCramming = serverWorld.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
                int crammingLimit = maxCramming - 1;
                Predicate canBePushedByPredicate = Sepals.CONFIG.isEnableSepalsQuickCanBePushByEntityPredicate() ? SepalsEntityPredicates.quickCanBePushedBy(this) : EntitySelector.pushableBy((Entity)this);
                if (maxCramming > 0) {
                    new SepalsWorldEntityIntersects().quickInterestOtherEntities((Level)serverWorld, this, this.getBoundingBox(), canBePushedByPredicate, this::doPush, target -> {
                        if (this.random.nextInt(4) == 0) {
                            this.hurtServer(serverWorld, this.damageSources().cramming(), 6.0f);
                        }
                    }, crammingLimit);
                } else {
                    new SepalsWorldEntityIntersects().quickInterestOtherEntities((Level)serverWorld, this, this.getBoundingBox(), canBePushedByPredicate, this::doPush);
                }
                ci.cancel();
            }
        }
    }
}

