/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain.sensor.nearest;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.entity.ai.cache.SepalsLivingTargetCache;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NearestLivingEntitySensor.class})
public abstract class NearestLivingEntitiesSensorMixin<T extends LivingEntity> {
    @Inject(method={"doTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void sense(ServerLevel world, T entity, CallbackInfo ci) {
        NearestVisibleLivingEntities cache;
        AABB box = entity.getBoundingBox().inflate(16.0, 16.0, 16.0);
        ObjectArrayList mobs = world.getEntitiesOfClass(LivingEntity.class, box, livingEntity -> livingEntity != entity && livingEntity.isAlive());
        boolean useQuickSort = Sepals.CONFIG.isNearestLivingEntitiesSensorUseQuickSort();
        Comparator<LivingEntity> comparator = Comparator.comparingDouble(arg_0 -> entity.distanceToSqr(arg_0));
        if (Sepals.CONFIG.isEnableSepalsLivingTargetCache()) {
            Catheter entities = Catheter.of((Collection)mobs, LivingEntity[]::new);
            if (useQuickSort) {
                ObjectArrays.quickSort((Object[])((LivingEntity[])entities.dArray()), comparator);
            } else {
                mobs.sort(comparator);
            }
            Object[] sources = (LivingEntity[])entities.array();
            mobs = ApricotCollectionFactor.arrayList((Object[])sources);
            Player[] players = (Player[])entities.filter(e -> e instanceof Player).varyTo(Player.class::cast).arrayGenerator(Player[]::new).safeArray();
            cache = new SepalsLivingTargetCache(world, (LivingEntity)entity, (LivingEntity[])sources, players);
        } else {
            if (useQuickSort) {
                Object[] entitiesArray = (LivingEntity[])mobs.toArray(LivingEntity[]::new);
                ObjectArrays.quickSort((Object[])entitiesArray, comparator);
                mobs = Arrays.asList(entitiesArray);
            } else {
                mobs.sort(comparator);
            }
            cache = new NearestVisibleLivingEntities(world, entity, (List)mobs);
        }
        Brain brain = entity.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)mobs);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)cache);
        ci.cancel();
    }
}

