/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.ai.brain.villager;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsRandomTask;
import com.github.cao.awa.sepals.entity.ai.task.look.SepalsLookAtPlayerTask;
import com.github.cao.awa.sepals.entity.ai.task.poi.SepalsFindPointOfInterestTask;
import com.github.cao.awa.sepals.entity.ai.task.rest.SepalsWakeUpTask;
import com.github.cao.awa.sepals.entity.ai.task.wait.SepalsWaitTask;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.behavior.AssignProfessionFromJobSite;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.behavior.GoToClosestVillage;
import net.minecraft.world.entity.ai.behavior.GoToPotentialJobSite;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.InsideBrownianWalk;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.JumpOnBed;
import net.minecraft.world.entity.ai.behavior.LookAndFollowTradingPlayerSink;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PlayTagWithOtherKids;
import net.minecraft.world.entity.ai.behavior.PoiCompetitorScan;
import net.minecraft.world.entity.ai.behavior.ReactToBell;
import net.minecraft.world.entity.ai.behavior.ResetProfession;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetClosestHomeAsWalkTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetRaidStatus;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromBlockMemory;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.ShowTradesToPlayer;
import net.minecraft.world.entity.ai.behavior.SleepInBed;
import net.minecraft.world.entity.ai.behavior.SocializeAtBell;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoiList;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.TradeWithVillager;
import net.minecraft.world.entity.ai.behavior.TriggerGate;
import net.minecraft.world.entity.ai.behavior.UpdateActivityFromSchedule;
import net.minecraft.world.entity.ai.behavior.UseBonemeal;
import net.minecraft.world.entity.ai.behavior.ValidateNearbyPoi;
import net.minecraft.world.entity.ai.behavior.VillageBoundRandomStroll;
import net.minecraft.world.entity.ai.behavior.VillagerCalmDown;
import net.minecraft.world.entity.ai.behavior.VillagerGoalPackages;
import net.minecraft.world.entity.ai.behavior.VillagerMakeLove;
import net.minecraft.world.entity.ai.behavior.VillagerPanicTrigger;
import net.minecraft.world.entity.ai.behavior.WorkAtComposter;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.behavior.YieldJobSite;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerGoalPackages.class})
public abstract class VillagerTaskListProviderMixin {
    @Unique
    private static Pair<Integer, BehaviorControl<LivingEntity>> createFreeFollowTask() {
        return Pair.of((Object)5, new SepalsRandomTask(ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.CAT, (float)8.0f), (Object)8), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.VILLAGER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SepalsLookAtPlayerTask.create(8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.WATER_CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.AXOLOTLS, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.WATER_AMBIENT, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.MONSTER, (float)8.0f), (Object)1), (Object)Pair.of((Object)new SepalsWaitTask(30, 60), (Object)2))));
    }

    @Unique
    private static Pair<Integer, BehaviorControl<LivingEntity>> createBusyFollowTask() {
        return Pair.of((Object)5, new SepalsRandomTask(ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.VILLAGER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SepalsLookAtPlayerTask.create(8.0f), (Object)2), (Object)Pair.of((Object)new SepalsWaitTask(30, 60), (Object)8))));
    }

    @Inject(method={"getCorePackage(Lnet/minecraft/core/Holder;F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createCoreTasks(Holder<VillagerProfession> profession, float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)ImmutableList.of((Object)Pair.of((Object)0, (Object)new Swim(0.8f)), (Object)Pair.of((Object)0, (Object)InteractWithDoor.create()), (Object)Pair.of((Object)0, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)0, (Object)new VillagerPanicTrigger()), (Object)Pair.of((Object)0, SepalsWakeUpTask.create()), (Object)Pair.of((Object)0, (Object)ReactToBell.create()), (Object)Pair.of((Object)0, (Object)SetRaidStatus.create()), (Object)Pair.of((Object)0, (Object)ValidateNearbyPoi.create((Predicate)((VillagerProfession)profession.value()).heldJobSite(), (MemoryModuleType)MemoryModuleType.JOB_SITE)), (Object)Pair.of((Object)0, (Object)ValidateNearbyPoi.create((Predicate)((VillagerProfession)profession.value()).acquirableJobSite(), (MemoryModuleType)MemoryModuleType.POTENTIAL_JOB_SITE)), (Object)Pair.of((Object)1, (Object)new MoveToTargetSink()), (Object)Pair.of((Object)2, (Object)PoiCompetitorScan.create()), (Object)Pair.of((Object)3, (Object)new LookAndFollowTradingPlayerSink(speed)), (Object[])new Pair[]{Pair.of((Object)5, (Object)GoToWantedItem.create((float)speed, (boolean)false, (int)4)), Pair.of((Object)6, SepalsFindPointOfInterestTask.create(((VillagerProfession)profession.value()).acquirableJobSite(), (MemoryModuleType<GlobalPos>)MemoryModuleType.JOB_SITE, (MemoryModuleType<GlobalPos>)MemoryModuleType.POTENTIAL_JOB_SITE, true, Optional.empty(), (world, pos) -> true)), Pair.of((Object)7, (Object)new GoToPotentialJobSite(speed)), Pair.of((Object)8, (Object)YieldJobSite.create((float)speed)), Pair.of((Object)10, SepalsFindPointOfInterestTask.create(poiType -> poiType.is(PoiTypes.HOME), (MemoryModuleType<GlobalPos>)MemoryModuleType.HOME, false, Optional.of((byte)14), (world, pos) -> {
                BlockState blockState = world.getBlockState(pos);
                return blockState.is(BlockTags.BEDS) && (Boolean)blockState.getValue((Property)BedBlock.OCCUPIED) == false;
            })), Pair.of((Object)10, SepalsFindPointOfInterestTask.create(poiType -> poiType.is(PoiTypes.MEETING), (MemoryModuleType<GlobalPos>)MemoryModuleType.MEETING_POINT, true, Optional.of((byte)14))), Pair.of((Object)10, (Object)AssignProfessionFromJobSite.create()), Pair.of((Object)10, (Object)ResetProfession.create())}));
        }
    }

    @Inject(method={"getMeetPackage(Lnet/minecraft/core/Holder;F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createMeetTasks(Holder<VillagerProfession> profession, float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)ImmutableList.of((Object)Pair.of((Object)2, (Object)TriggerGate.triggerOneShuffled((List)ImmutableList.of((Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.MEETING_POINT, (float)0.4f, (int)40), (Object)2), (Object)Pair.of((Object)SocializeAtBell.create(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromBlockMemory.create((MemoryModuleType)MemoryModuleType.MEETING_POINT, (float)speed, (int)6, (int)100, (int)200)), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)3, (Object)ValidateNearbyPoi.create(poiType -> poiType.is(PoiTypes.MEETING), (MemoryModuleType)MemoryModuleType.MEETING_POINT)), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.INTERACTION_TARGET), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new TradeWithVillager(), (Object)1)))), VillagerTaskListProviderMixin.createFreeFollowTask(), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create())));
        }
    }

    @Inject(method={"getWorkPackage(Lnet/minecraft/core/Holder;F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createWorkTasks(Holder<VillagerProfession> profession, float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            Object villagerWorkTask = profession == VillagerProfession.FARMER ? new WorkAtComposter() : new WorkAtPoi();
            cir.setReturnValue((Object)ImmutableList.of(VillagerTaskListProviderMixin.createBusyFollowTask(), (Object)Pair.of((Object)5, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)villagerWorkTask, (Object)7), (Object)Pair.of((Object)StrollAroundPoi.create((MemoryModuleType)MemoryModuleType.JOB_SITE, (float)0.4f, (int)4), (Object)2), (Object)Pair.of((Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.JOB_SITE, (float)0.4f, (int)1, (int)10), (Object)5), (Object)Pair.of((Object)StrollToPoiList.create((MemoryModuleType)MemoryModuleType.SECONDARY_JOB_SITE, (float)speed, (int)1, (int)6, (MemoryModuleType)MemoryModuleType.JOB_SITE), (Object)5), (Object)Pair.of((Object)new HarvestFarmland(), (Object)(profession.is(VillagerProfession.FARMER) ? 2 : 5)), (Object)Pair.of((Object)new UseBonemeal(), (Object)(profession.is(VillagerProfession.FARMER) ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromBlockMemory.create((MemoryModuleType)MemoryModuleType.JOB_SITE, (float)speed, (int)9, (int)100, (int)1200)), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create())));
        }
    }

    @Inject(method={"getIdlePackage(Lnet/minecraft/core/Holder;F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createIdleTasks(Holder<VillagerProfession> profession, float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)ImmutableList.of((Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speed, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.VILLAGER, (int)8, AgeableMob::canBreed, AgeableMob::canBreed, (MemoryModuleType)MemoryModuleType.BREED_TARGET, (float)speed, (int)2), (Object)1), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.CAT, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speed, (int)2), (Object)1), (Object)Pair.of((Object)VillageBoundRandomStroll.create((float)speed), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)speed, (int)2), (Object)1), (Object)Pair.of((Object)new JumpOnBed(speed), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GiveGiftToHero(100)), (Object)Pair.of((Object)3, (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)), (Object)Pair.of((Object)3, (Object)new ShowTradesToPlayer(400, 1600)), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.INTERACTION_TARGET), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new TradeWithVillager(), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.BREED_TARGET), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)new VillagerMakeLove(), (Object)1)))), VillagerTaskListProviderMixin.createFreeFollowTask(), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create())));
        }
    }

    @Inject(method={"getPanicPackage(Lnet/minecraft/core/Holder;F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createPanicTasks(Holder<VillagerProfession> profession, float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            float f = speed * 1.5f;
            cir.setReturnValue((Object)ImmutableList.of((Object)Pair.of((Object)0, (Object)VillagerCalmDown.create()), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.NEAREST_HOSTILE, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)VillageBoundRandomStroll.create((float)f, (int)2, (int)2)), VillagerTaskListProviderMixin.createBusyFollowTask()));
        }
    }

    @Inject(method={"getPlayPackage(F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createPlayTasks(float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)ImmutableList.of((Object)Pair.of((Object)0, (Object)new MoveToTargetSink(80, 120)), VillagerTaskListProviderMixin.createFreeFollowTask(), (Object)Pair.of((Object)5, (Object)PlayTagWithOtherKids.create()), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.VILLAGER, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speed, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.CAT, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)speed, (int)2), (Object)1), (Object)Pair.of((Object)VillageBoundRandomStroll.create((float)speed), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)speed, (int)2), (Object)1), (Object)Pair.of((Object)new JumpOnBed(speed), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create())));
        }
    }

    @Inject(method={"getRestPackage(Lnet/minecraft/core/Holder;F)Lcom/google/common/collect/ImmutableList;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createRestTasks(Holder<VillagerProfession> profession, float speed, CallbackInfoReturnable<ImmutableList<Pair<Integer, ? extends BehaviorControl<? super Villager>>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)ImmutableList.of((Object)Pair.of((Object)2, (Object)SetWalkTargetFromBlockMemory.create((MemoryModuleType)MemoryModuleType.HOME, (float)speed, (int)1, (int)150, (int)1200)), (Object)Pair.of((Object)3, (Object)ValidateNearbyPoi.create(poiType -> poiType.is(PoiTypes.HOME), (MemoryModuleType)MemoryModuleType.HOME)), (Object)Pair.of((Object)3, (Object)new SleepInBed()), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)SetClosestHomeAsWalkTarget.create((float)speed), (Object)1), (Object)Pair.of((Object)InsideBrownianWalk.create((float)speed), (Object)4), (Object)Pair.of((Object)GoToClosestVillage.create((float)speed, (int)4), (Object)2), (Object)Pair.of((Object)new DoNothing(20, 40), (Object)2)))), VillagerTaskListProviderMixin.createBusyFollowTask(), (Object)Pair.of((Object)99, (Object)UpdateActivityFromSchedule.create())));
        }
    }

    @Inject(method={"getFullLookBehavior()Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createFreeFollowTask(CallbackInfoReturnable<Pair<Integer, BehaviorControl<LivingEntity>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)Pair.of((Object)5, new SepalsRandomTask(ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.CAT, (float)8.0f), (Object)8), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.VILLAGER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SepalsLookAtPlayerTask.create(8.0f), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.WATER_CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.AXOLOTLS, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.WATER_AMBIENT, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((MobCategory)MobCategory.MONSTER, (float)8.0f), (Object)1), (Object)Pair.of((Object)new SepalsWaitTask(30, 60), (Object)2)))));
        }
    }

    @Inject(method={"getMinimalLookBehavior()Lcom/mojang/datafixers/util/Pair;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void createBusyFollowTask(CallbackInfoReturnable<Pair<Integer, BehaviorControl<LivingEntity>>> cir) {
        if (Sepals.CONFIG.isEnableSepalsVillager()) {
            cir.setReturnValue((Object)Pair.of((Object)5, new SepalsRandomTask(ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.VILLAGER, (float)8.0f), (Object)2), (Object)Pair.of((Object)SepalsLookAtPlayerTask.create(8.0f), (Object)2), (Object)Pair.of((Object)new SepalsWaitTask(30, 60), (Object)8)))));
        }
    }
}

