/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.entity.item;

import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.item.BoxedItemEntities;
import com.github.cao.awa.sepals.mixin.entity.item.ItemEntityAccessor;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    @Unique
    private boolean isFireImmuneCached = false;
    @Unique
    private boolean fireImmune = false;

    public ItemEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    protected abstract boolean isMergable();

    @Shadow
    protected abstract void tryToMerge(ItemEntity var1);

    @Inject(method={"mergeWithNeighbours()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tryMerge(CallbackInfo ci) {
        if (Sepals.CONFIG.isEnableSepalsItemMerge()) {
            if (this.isMergable()) {
                this.getBoxedEntities(this.level(), this.getBoundingBox().inflate(0.5, 0.0, 0.5), itemEntity -> {
                    this.tryToMerge((ItemEntity)itemEntity);
                    return this.isRemoved();
                });
            }
            ci.cancel();
        }
    }

    @Unique
    public void getBoxedEntities(Level world, AABB box, Predicate<ItemEntity> invalidate) {
        if (world instanceof BoxedItemEntities) {
            BoxedItemEntities entities = (BoxedItemEntities)world;
            entities.setEntities(world.getEntities(EntityTypeTest.forClass(ItemEntity.class), box, entity -> entity != this && ((ItemEntityAccessor)entity).invokeCanMerge()));
            for (ItemEntity entity2 : entities.entities()) {
                if (entity2 == this) continue;
                if (!((ItemEntityAccessor)entity2).invokeCanMerge()) {
                    entities.invalidate(entity2);
                    continue;
                }
                if (!entity2.getBoundingBox().intersects(box)) continue;
                entities.invalidate((ItemEntity)this);
                if (!invalidate.test(entity2)) continue;
                break;
            }
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (this.isFireImmuneCached) {
            cir.setReturnValue((Object)this.fireImmune);
        }
    }

    @Inject(method={"fireImmune()Z"}, at={@At(value="RETURN")})
    private void cacheFireImmune(CallbackInfoReturnable<Boolean> cir) {
        this.isFireImmuneCached = true;
        this.fireImmune = (Boolean)cir.getReturnValue();
    }
}

