/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.world;

import com.github.cao.awa.sepals.item.BoxedItemEntities;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class ServerWorldMixin
implements BoxedItemEntities {
    @Unique
    private final Map<Integer, ItemEntity> entities = new Int2ObjectOpenHashMap();

    @Override
    @Unique
    public void sepals$addEntity(ItemEntity entity) {
        this.entities.put(entity.getId(), entity);
    }

    @Override
    @Unique
    public boolean sepals$isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    @Unique
    public void sepals$setEntities(List<ItemEntity> entities) {
        for (ItemEntity entity : entities) {
            this.entities.put(entity.getId(), entity);
        }
    }

    @Override
    @Unique
    public void sepals$clearItemBoxed() {
        this.entities.clear();
    }

    @Override
    @Unique
    public void sepals$invalidate(ItemEntity entity) {
        this.entities.remove(entity.getId());
    }

    @Override
    @Unique
    public Collection<ItemEntity> sepals$entities() {
        return CollectionFactor.hashSet(this.entities.values());
    }

    @Override
    @Unique
    public Collection<ItemEntity> sepals$entitiesAndInvalidate(ItemEntity entity) {
        if (!this.entities.containsKey(entity.getId())) {
            this.entities.remove(entity.getId());
        }
        return this.entities.values();
    }

    @Inject(method={"tick(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/EntityTickList;forEach(Ljava/util/function/Consumer;)V")})
    public void resetItemEntities(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        this.clearItemBoxed();
    }
}

