/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.world.poi;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.collection.listener.ActivableLong2ObjectMap;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestSetAccessor;
import com.github.cao.awa.sepals.world.poi.RegionBasedStorageSectionExtended;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestSet;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionStorage.class})
public abstract class SerializingRegionBasedStorageMixin<R>
implements RegionBasedStorageSectionExtended<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> storage;
    @Shadow
    @Final
    protected LevelHeightAccessor levelHeightAccessor;
    @Unique
    private Map<Long, BitSet> columns;

    @Shadow
    protected abstract Optional<R> getOrLoad(long var1);

    @Shadow
    public abstract CompletableFuture<?> prefetch(ChunkPos var1);

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/storage/SimpleRegionStorage;Lcom/mojang/serialization/Codec;Ljava/util/function/Function;Ljava/util/function/BiFunction;Ljava/util/function/Function;Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/level/chunk/storage/ChunkIOErrorReporter;Lnet/minecraft/world/level/LevelHeightAccessor;)V"}, at={@At(value="RETURN")}, order=0x7FFFFFFF)
    private void init(SimpleRegionStorage storageAccess, Codec codec, Function serializer, BiFunction deserializer, Function factory, RegistryAccess registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.storage = new ActivableLong2ObjectMap<Optional<R>>(this.storage).triggerPutAndRemoved(this::handlePut, this::handleRemoved);
    }

    @Unique
    private void handleRemoved(long key, Optional<R> value) {
        int z;
        int x;
        long pos;
        BitSet flags;
        int y = SectionPos.y((long)key) - this.levelHeightAccessor.getMinSectionY();
        if (y > -1 && y < this.levelHeightAccessor.getSectionsCount() && (flags = this.columns.get(pos = ChunkPos.asLong((int)(x = SectionPos.x((long)key)), (int)(z = SectionPos.z((long)key))))) != null) {
            flags.clear(y);
            if (flags.isEmpty()) {
                this.columns.remove(pos);
            }
        }
    }

    @Unique
    private void handlePut(long key, Optional<R> value) {
        int y = SectionPos.y((long)key) - this.levelHeightAccessor.getMinSectionY();
        if (y > -1 && y < this.levelHeightAccessor.getSectionsCount()) {
            int x = SectionPos.x((long)key);
            int z = SectionPos.z((long)key);
            BitSet flags = this.columns.computeIfAbsent(ChunkPos.asLong((int)x, (int)z), k -> new BitSet());
            flags.set(y, value.isPresent());
        }
    }

    @Override
    public Stream<PoiRecord> sepals$getInChunk(Predicate<Holder<PoiType>> typePredicate, ChunkPos chunkPos, PoiManager.Occupancy occupationStatus) {
        return IntStream.rangeClosed(this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).mapToObj(coordinate -> this.getOrLoad(SectionPos.of((ChunkPos)chunkPos, (int)coordinate).asLong())).filter(Optional::isPresent).flatMap(poiSet -> SepalsPointOfInterestSet.get(((PointOfInterestSetAccessor)poiSet.get()).getPointsOfInterestByType(), typePredicate, occupationStatus).stream());
    }

    @Override
    public Catheter<R> sepals$getWithinChunkColumn(int x, int z) {
        BitSet sectionsWithPOI = this.getNonEmptyPOISections(x, z);
        if (sectionsWithPOI.isEmpty()) {
            return Catheter.make((Object[])new Object[0]);
        }
        ObjectArrayList list = ApricotCollectionFactor.arrayList();
        int minYSection = this.levelHeightAccessor.getMinSectionY();
        int chunkYIndex = sectionsWithPOI.nextSetBit(0);
        while (chunkYIndex != -1) {
            int chunkY = chunkYIndex + minYSection;
            Object r = ((Optional)this.storage.get(SectionPos.asLong((int)x, (int)chunkY, (int)z))).orElse(null);
            if (r != null) {
                list.add(r);
            }
            chunkYIndex = sectionsWithPOI.nextSetBit(chunkYIndex + 1);
        }
        return Catheter.of((Collection)list);
    }

    @Unique
    private BitSet getNonEmptyPOISections(int chunkX, int chunkZ) {
        long pos = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        BitSet flags = this.getNonEmptySections(pos, false);
        if (flags == null) {
            this.prefetch(new ChunkPos(pos));
            return this.getNonEmptySections(pos, true);
        }
        return flags;
    }

    @Unique
    private BitSet getNonEmptySections(long pos, boolean required) {
        BitSet set = this.columns.get(pos);
        if (set == null && required) {
            throw new NullPointerException("No data is present for column: " + String.valueOf(new ChunkPos(pos)));
        }
        return set;
    }
}

