/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.world.poi;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestAccessor;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestSetAccessor;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestStorageAccessor;
import com.github.cao.awa.sepals.mixin.world.storage.SerializingRegionBasedStorageAccessor;
import com.github.cao.awa.sepals.world.poi.RegionBasedStorageSectionExtended;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class SepalsPointOfInterestStorage {
    public static Function4<PoiManager, Predicate<Holder<PoiType>>, ChunkPos, PoiManager.Occupancy, Stream<PoiRecord>> getInChunkFunction = SepalsPointOfInterestStorage::sepalsGetInChunk;

    public static void onLithiumLoaded() {
        SepalsPointOfInterestStorage.onRequiredVanillaGetInChunk();
    }

    public static void onMoonriseLoaded() {
        SepalsPointOfInterestStorage.onRequiredVanillaGetInChunk();
    }

    public static void onRequiredVanillaGetInChunk() {
        getInChunkFunction = PoiManager::getInChunk;
    }

    public static void onRequiredSepalsGetInChunk() {
        if (Sepals.isAbleToUseSepalsGetInChunkFunction()) {
            SepalsPointOfInterestStorage.forceRequiredSepalsGetInChunk();
        }
    }

    public static void forceRequiredSepalsGetInChunk() {
        getInChunkFunction = SepalsPointOfInterestStorage::sepalsGetInChunk;
    }

    public static Stream<PoiRecord> sepalsGetInChunk(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, ChunkPos chunkPos, PoiManager.Occupancy occupationStatus) {
        return ((RegionBasedStorageSectionExtended)storage).sepals$getInChunk(typePredicate, chunkPos, occupationStatus);
    }

    public static Catheter<PoiRecord> getInSquare(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        int i = Math.floorDiv(radius, 16) + 1;
        return Catheter.of((Collection)ChunkPos.rangeClosed((ChunkPos)new ChunkPos(pos), (int)i).flatMap(chunkPos -> SepalsPointOfInterestStorage.getInChunk(storage, typePredicate, chunkPos, occupationStatus)).filter(poi -> {
            BlockPos blockPos2 = poi.getPos();
            return Math.abs(blockPos2.getX() - pos.getX()) <= radius && Math.abs(blockPos2.getZ() - pos.getZ()) <= radius;
        }).collect(Collectors.toSet()));
    }

    @VisibleForDebug
    public static Stream<PoiRecord> getInChunk(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, ChunkPos chunkPos, PoiManager.Occupancy occupationStatus) {
        return (Stream)getInChunkFunction.apply((Object)storage, typePredicate, (Object)chunkPos, (Object)occupationStatus);
    }

    public static Catheter<PoiRecord> get(PoiSection set, Predicate<Holder<PoiType>> predicate, PoiManager.Occupancy occupationStatus) {
        return Catheter.of(SepalsPointOfInterestStorage.accessor(set).getPointsOfInterestByType().entrySet()).filter(predicate, Map.Entry::getKey).collectionFlatTo(Map.Entry::getValue).filter(occupationStatus.getTest());
    }

    public static Catheter<PoiRecord> getInCircle(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        double i = radius * radius;
        return SepalsPointOfInterestStorage.getInSquare(storage, typePredicate, pos, radius, occupationStatus).discard(poiPos -> poiPos.distSqr((Vec3i)pos) > i, PoiRecord::getPos);
    }

    public static Catheter<BlockPos> getPositions(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).varyTo(PoiRecord::getPos).filter(posPredicate);
    }

    public static Catheter<Pair<Holder<PoiType>, BlockPos>> getTypesAndPositions(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).filter(posPredicate, PoiRecord::getPos).varyTo(poi -> Pair.of((Object)poi.getPoiType(), (Object)poi.getPos())).arrayGenerator(Pair[]::new);
    }

    public static Catheter<Pair<Holder<PoiType>, BlockPos>> getSortedTypesAndPositions(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return SepalsPointOfInterestStorage.getTypesAndPositions(storage, typePredicate, posPredicate, pos, radius, occupationStatus).sort(Comparator.comparingDouble(pair -> ((BlockPos)pair.getSecond()).distSqr((Vec3i)pos)));
    }

    public static Optional<BlockPos> getPosition(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return Optional.ofNullable((BlockPos)SepalsPointOfInterestStorage.getPositions(storage, typePredicate, posPredicate, pos, radius, occupationStatus).findFirst(x -> true));
    }

    public static Optional<BlockPos> getNearestPosition(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return Optional.ofNullable((BlockPos)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).varyTo(PoiRecord::getPos).min(Comparator.comparingDouble(blockPos2 -> blockPos2.distSqr((Vec3i)pos))));
    }

    public static Optional<Pair<Holder<PoiType>, BlockPos>> getNearestTypeAndPosition(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return Optional.ofNullable((PoiRecord)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).min(Comparator.comparingDouble(poi -> poi.getPos().distSqr((Vec3i)pos)))).map(poi -> Pair.of((Object)poi.getPoiType(), (Object)poi.getPos()));
    }

    public static Optional<BlockPos> getNearestPosition(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy occupationStatus) {
        return Optional.ofNullable((BlockPos)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).varyTo(PoiRecord::getPos).filter(posPredicate).min(Comparator.comparingDouble(blockPos2 -> blockPos2.distSqr((Vec3i)pos))));
    }

    public static Optional<BlockPos> getPosition(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, BiPredicate<Holder<PoiType>, BlockPos> biPredicate, BlockPos pos, int radius) {
        return Optional.ofNullable((PoiRecord)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, PoiManager.Occupancy.HAS_SPACE).filter(poi -> biPredicate.test(poi.getPoiType(), poi.getPos())).findFirst(x -> true)).map(poi -> {
            ((PointOfInterestAccessor)poi).invokeReserveTicket();
            return poi.getPos();
        });
    }

    public static Optional<BlockPos> getPosition(PoiManager storage, Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> positionPredicate, PoiManager.Occupancy occupationStatus, BlockPos pos, int radius, RandomSource random) {
        Catheter<PoiRecord> catheter = SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus);
        catheter.shuffle(() -> ((RandomSource)random).nextLong());
        return Optional.ofNullable((PoiRecord)catheter.filter(poi -> positionPredicate.test(poi.getPos())).findFirst(x -> true)).map(PoiRecord::getPos);
    }

    public static <T> void shuffle(T[] elements, RandomSource random) {
        int i;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            T fromElement = elements[swapFrom];
            T toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
    }

    public static void preloadChunks(PoiManager storage, LevelReader world, BlockPos pos, int radius) {
        Catheter.of((Object[])((SectionPos[])SectionPos.aroundChunk((ChunkPos)new ChunkPos(pos), (int)Math.floorDiv(radius, 16), (int)SepalsPointOfInterestStorage.storageAccessor(storage).getWorld().getMinSectionY(), (int)SepalsPointOfInterestStorage.storageAccessor(storage).getWorld().getMaxSectionY()).toArray(SectionPos[]::new))).varyTo(sectionPos -> Pair.of((Object)sectionPos, SepalsPointOfInterestStorage.storageAccessor(storage).invokeGet(sectionPos.asLong()))).discard(pair -> ((Optional)pair.getSecond()).map(SepalsPointOfInterestStorage::isValid).orElse(false)).varyTo(pair -> ((SectionPos)pair.getFirst()).chunk()).filter(chunkPos -> SepalsPointOfInterestStorage.accessor(storage).getPreloadedChunks().add(chunkPos.toLong())).each(chunkPos -> world.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.EMPTY));
    }

    private static PointOfInterestStorageAccessor accessor(PoiManager storage) {
        return (PointOfInterestStorageAccessor)storage;
    }

    private static PointOfInterestSetAccessor accessor(PoiSection set) {
        return (PointOfInterestSetAccessor)set;
    }

    private static boolean isValid(PoiSection set) {
        return SepalsPointOfInterestStorage.accessor(set).invokeIsValid();
    }

    private static SerializingRegionBasedStorageAccessor<PoiSection> storageAccessor(PoiManager storage) {
        return (SerializingRegionBasedStorageAccessor)storage;
    }
}

