/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.cache;

import com.github.cao.awa.catheter.Catheter;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4148;
import net.minecraft.class_6670;

public class SepalsLivingTargetCache
extends class_6670 {
    private final class_1309[] entities;
    private final class_1657[] players;
    private final Object2BooleanOpenHashMap<class_1309> directSuccess;
    private final Predicate<class_1309> compute;

    public SepalsLivingTargetCache(class_3218 world, class_1309 owner, class_1309[] entities, class_1657[] players) {
        super(world, owner, Collections.EMPTY_LIST);
        this.entities = entities;
        this.players = players;
        this.directSuccess = new Object2BooleanOpenHashMap(entities.length);
        Predicate<class_1309> predicate = entity -> class_4148.method_30954((class_3218)world, (class_1309)owner, (class_1309)entity);
        this.compute = entity -> this.directSuccess.computeIfAbsent(entity, predicate);
    }

    public Optional<class_1309> method_38975(Predicate<class_1309> predicate) {
        class_1309[] entities;
        for (class_1309 entity : entities = this.entities) {
            if (!predicate.test(entity) || !this.compute.test(entity)) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public Optional<class_1657> findFirstPlayer(Predicate<class_1657> predicate) {
        return this.findFirstPlayer(predicate, () -> true);
    }

    public Optional<class_1657> findFirstPlayer(Predicate<class_1657> predicate, BooleanSupplier canTargetPredicateWhen) {
        class_1657[] players;
        for (class_1657 player : players = this.players) {
            if (!predicate.test(player) || !canTargetPredicateWhen.getAsBoolean() || !this.compute.test((class_1309)player)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public Optional<class_1657> findFirstPlayer(Predicate<class_1657> predicate, Predicate<class_1657> canTargetPredicateWhen) {
        class_1657[] players;
        for (class_1657 player : players = this.players) {
            if (!predicate.test(player) || !canTargetPredicateWhen.test(player) || !this.compute.test((class_1309)player)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public Iterable<class_1309> method_38978(Predicate<class_1309> predicate) {
        return () -> this.method_38980(predicate).iterator();
    }

    public Stream<class_1309> method_38980(Predicate<class_1309> predicate) {
        return Arrays.stream(this.entities).filter(entity -> predicate.test((class_1309)entity) && this.compute.test((class_1309)entity));
    }

    public List<class_1309> collect(Predicate<class_1309> predicate) {
        return Catheter.of((Object[])this.entities).filterTo(entity -> predicate.test((class_1309)entity) && this.compute.test((class_1309)entity)).list();
    }

    public boolean method_38972(class_1309 target) {
        class_1309[] entities;
        for (class_1309 entity : entities = this.entities) {
            if (entity != target) continue;
            return this.compute.test(entity);
        }
        return false;
    }

    public boolean method_38981(Predicate<class_1309> predicate) {
        class_1309[] entities;
        for (class_1309 entity : entities = this.entities) {
            if (!predicate.test(entity) || !this.compute.test(entity)) continue;
            return true;
        }
        return false;
    }
}

