/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.world.poi;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.Sepals;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestAccessor;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestSetAccessor;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestStorageAccessor;
import com.github.cao.awa.sepals.mixin.world.storage.SerializingRegionBasedStorageAccessor;
import com.github.cao.awa.sepals.world.poi.RegionBasedStorageSectionExtended;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2806;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_5996;
import net.minecraft.class_6880;

public class SepalsPointOfInterestStorage {
    public static Function4<class_4153, Predicate<class_6880<class_4158>>, class_1923, class_4153.class_4155, Stream<class_4156>> getInChunkFunction = SepalsPointOfInterestStorage::sepalsGetInChunk;

    public static void onLithiumLoaded() {
        SepalsPointOfInterestStorage.onRequiredVanillaGetInChunk();
    }

    public static void onMoonriseLoaded() {
        SepalsPointOfInterestStorage.onRequiredVanillaGetInChunk();
    }

    public static void onRequiredVanillaGetInChunk() {
        getInChunkFunction = class_4153::method_19123;
    }

    public static void onRequiredSepalsGetInChunk() {
        if (Sepals.isAbleToUseSepalsGetInChunkFunction()) {
            SepalsPointOfInterestStorage.forceRequiredSepalsGetInChunk();
        }
    }

    public static void forceRequiredSepalsGetInChunk() {
        getInChunkFunction = SepalsPointOfInterestStorage::sepalsGetInChunk;
    }

    public static Stream<class_4156> sepalsGetInChunk(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, class_1923 chunkPos, class_4153.class_4155 occupationStatus) {
        return ((RegionBasedStorageSectionExtended)storage).sepals$getInChunk(typePredicate, chunkPos, occupationStatus);
    }

    public static Catheter<class_4156> getInSquare(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        int i = Math.floorDiv(radius, 16) + 1;
        return Catheter.of((Collection)class_1923.method_19280((class_1923)new class_1923(pos), (int)i).flatMap(chunkPos -> SepalsPointOfInterestStorage.getInChunk(storage, typePredicate, chunkPos, occupationStatus)).filter(poi -> {
            class_2338 blockPos2 = poi.method_19141();
            return Math.abs(blockPos2.method_10263() - pos.method_10263()) <= radius && Math.abs(blockPos2.method_10260() - pos.method_10260()) <= radius;
        }).collect(Collectors.toSet()));
    }

    @class_5996
    public static Stream<class_4156> getInChunk(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, class_1923 chunkPos, class_4153.class_4155 occupationStatus) {
        return (Stream)getInChunkFunction.apply((Object)storage, typePredicate, (Object)chunkPos, (Object)occupationStatus);
    }

    public static Catheter<class_4156> get(class_4157 set, Predicate<class_6880<class_4158>> predicate, class_4153.class_4155 occupationStatus) {
        return Catheter.of(SepalsPointOfInterestStorage.accessor(set).getPointsOfInterestByType().entrySet()).filter(predicate, Map.Entry::getKey).collectionFlatTo(Map.Entry::getValue).filter(occupationStatus.method_19135());
    }

    public static Catheter<class_4156> getInCircle(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        double i = radius * radius;
        return SepalsPointOfInterestStorage.getInSquare(storage, typePredicate, pos, radius, occupationStatus).discard(poiPos -> poiPos.method_10262((class_2382)pos) > i, class_4156::method_19141);
    }

    public static Catheter<class_2338> getPositions(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).varyTo(class_4156::method_19141).filter(posPredicate);
    }

    public static Catheter<Pair<class_6880<class_4158>, class_2338>> getTypesAndPositions(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).filter(posPredicate, class_4156::method_19141).varyTo(poi -> Pair.of((Object)poi.method_19142(), (Object)poi.method_19141())).arrayGenerator(Pair[]::new);
    }

    public static Catheter<Pair<class_6880<class_4158>, class_2338>> getSortedTypesAndPositions(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return SepalsPointOfInterestStorage.getTypesAndPositions(storage, typePredicate, posPredicate, pos, radius, occupationStatus).sort(Comparator.comparingDouble(pair -> ((class_2338)pair.getSecond()).method_10262((class_2382)pos)));
    }

    public static Optional<class_2338> getPosition(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return Optional.ofNullable((class_2338)SepalsPointOfInterestStorage.getPositions(storage, typePredicate, posPredicate, pos, radius, occupationStatus).findFirst(x -> true));
    }

    public static Optional<class_2338> getNearestPosition(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return Optional.ofNullable((class_2338)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).varyTo(class_4156::method_19141).min(Comparator.comparingDouble(blockPos2 -> blockPos2.method_10262((class_2382)pos))));
    }

    public static Optional<Pair<class_6880<class_4158>, class_2338>> getNearestTypeAndPosition(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return Optional.ofNullable((class_4156)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).min(Comparator.comparingDouble(poi -> poi.method_19141().method_10262((class_2382)pos)))).map(poi -> Pair.of((Object)poi.method_19142(), (Object)poi.method_19141()));
    }

    public static Optional<class_2338> getNearestPosition(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> posPredicate, class_2338 pos, int radius, class_4153.class_4155 occupationStatus) {
        return Optional.ofNullable((class_2338)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus).varyTo(class_4156::method_19141).filter(posPredicate).min(Comparator.comparingDouble(blockPos2 -> blockPos2.method_10262((class_2382)pos))));
    }

    public static Optional<class_2338> getPosition(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, BiPredicate<class_6880<class_4158>, class_2338> biPredicate, class_2338 pos, int radius) {
        return Optional.ofNullable((class_4156)SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, class_4153.class_4155.field_18487).filter(poi -> biPredicate.test(poi.method_19142(), poi.method_19141())).findFirst(x -> true)).map(poi -> {
            ((PointOfInterestAccessor)poi).invokeReserveTicket();
            return poi.method_19141();
        });
    }

    public static Optional<class_2338> getPosition(class_4153 storage, Predicate<class_6880<class_4158>> typePredicate, Predicate<class_2338> positionPredicate, class_4153.class_4155 occupationStatus, class_2338 pos, int radius, class_5819 random) {
        Catheter<class_4156> catheter = SepalsPointOfInterestStorage.getInCircle(storage, typePredicate, pos, radius, occupationStatus);
        catheter.shuffle(() -> ((class_5819)random).method_43055());
        return Optional.ofNullable((class_4156)catheter.filter(poi -> positionPredicate.test(poi.method_19141())).findFirst(x -> true)).map(class_4156::method_19141);
    }

    public static <T> void shuffle(T[] elements, class_5819 random) {
        int i;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.method_43048(j);
            int swapFrom = j - 1;
            T fromElement = elements[swapFrom];
            T toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
    }

    public static void preloadChunks(class_4153 storage, class_4538 world, class_2338 pos, int radius) {
        Catheter.of((Object[])((class_4076[])class_4076.method_22446((class_1923)new class_1923(pos), (int)Math.floorDiv(radius, 16), (int)SepalsPointOfInterestStorage.storageAccessor(storage).getWorld().method_32891(), (int)SepalsPointOfInterestStorage.storageAccessor(storage).getWorld().method_31597()).toArray(class_4076[]::new))).varyTo(sectionPos -> Pair.of((Object)sectionPos, SepalsPointOfInterestStorage.storageAccessor(storage).invokeGet(sectionPos.method_18694()))).discard(pair -> ((Optional)pair.getSecond()).map(SepalsPointOfInterestStorage::isValid).orElse(false)).varyTo(pair -> ((class_4076)pair.getFirst()).method_18692()).filter(chunkPos -> SepalsPointOfInterestStorage.accessor(storage).getPreloadedChunks().add(chunkPos.method_8324())).each(chunkPos -> world.method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12798));
    }

    private static PointOfInterestStorageAccessor accessor(class_4153 storage) {
        return (PointOfInterestStorageAccessor)storage;
    }

    private static PointOfInterestSetAccessor accessor(class_4157 set) {
        return (PointOfInterestSetAccessor)set;
    }

    private static boolean isValid(class_4157 set) {
        return SepalsPointOfInterestStorage.accessor(set).invokeIsValid();
    }

    private static SerializingRegionBasedStorageAccessor<class_4157> storageAccessor(class_4153 storage) {
        return (SerializingRegionBasedStorageAccessor)storage;
    }
}

