/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.weight.SepalsWeighting;
import com.github.cao.awa.sepals.weight.WeightTable;
import com.github.cao.awa.sepals.weight.result.WeightingResult;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6030;
import net.minecraft.class_7;
import net.minecraft.class_8946;
import org.jetbrains.annotations.Nullable;

public class SepalsLongJumpTask<E extends class_1308>
extends class_4097<E> {
    private static final int[] RAM_RANGES = new int[]{65, 70, 75, 80};
    private final class_6019 cooldownRange;
    protected final int verticalRange;
    protected final int horizontalRange;
    protected final double maxRange;
    protected Catheter<class_2338> targets = null;
    protected Catheter<Target> precalculatedTargets = null;
    protected int precalculatedRange = 0;
    private int precalculatingIndex = 0;
    protected class_243 lastPos = null;
    protected boolean isNoRange = false;
    @Nullable
    protected class_243 lastTarget;
    protected int cooldown;
    protected long targetTime;
    private final Function<E, class_3414> entityToSound;
    private final BiPredicate<E, class_2338> jumpToPredicate;

    public SepalsLongJumpTask(class_6019 cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, class_3414> entityToSound) {
        this(cooldownRange, verticalRange, horizontalRange, maxRange, entityToSound, class_6030::method_45333);
    }

    public static <E extends class_1308> boolean shouldJumpTo(E entity, class_2680 posDownState, class_7 pathNodeType) {
        return posDownState.method_26216() && entity.method_5944(pathNodeType) == 0.0f;
    }

    public SepalsLongJumpTask(class_6019 cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, class_3414> entityToSound, BiPredicate<E, class_2338> jumpToPredicate) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_30244, (Object)class_4141.field_18457, (Object)class_4140.field_30245, (Object)class_4141.field_18457), 200);
        this.cooldownRange = cooldownRange;
        this.verticalRange = verticalRange;
        this.horizontalRange = horizontalRange;
        this.maxRange = maxRange;
        this.entityToSound = entityToSound;
        this.jumpToPredicate = jumpToPredicate;
    }

    protected boolean shouldRun(class_3218 serverWorld, class_1308 mobEntity) {
        boolean bl;
        boolean bl2 = bl = mobEntity.method_24828() && !mobEntity.method_5799() && !mobEntity.method_5771() && !serverWorld.method_8320(mobEntity.method_24515()).method_27852(class_2246.field_21211);
        if (!bl) {
            mobEntity.method_18868().method_18878(class_4140.field_30244, (Object)(this.cooldownRange.method_35008(serverWorld.field_9229) / 2));
        }
        return bl;
    }

    protected boolean shouldKeepRunning(class_3218 serverWorld, class_1308 mobEntity, long l) {
        boolean bl;
        boolean bl2 = bl = this.lastPos != null && this.lastPos.equals((Object)mobEntity.method_73189()) && this.cooldown > 0 && !mobEntity.method_5799() && (this.lastTarget != null || this.targets.isPresent());
        if (!bl && mobEntity.method_18868().method_18904(class_4140.field_30245).isEmpty()) {
            mobEntity.method_18868().method_18878(class_4140.field_30244, (Object)(this.cooldownRange.method_35008(serverWorld.field_9229) / 2));
            mobEntity.method_18868().method_18875(class_4140.field_18446);
        }
        return bl;
    }

    protected void run(class_3218 serverWorld, E mobEntity, long l) {
        this.lastTarget = null;
        this.cooldown = 20;
        this.lastPos = mobEntity.method_73189();
        class_2338 blockPos = mobEntity.method_24515();
        int i = blockPos.method_10263();
        int j = blockPos.method_10264();
        int k = blockPos.method_10260();
        this.precalculatedRange = 0;
        this.precalculatingIndex = 0;
        this.isNoRange = false;
        this.targets = Catheter.of(SepalsLongJumpTask.makeBlockPos(i - this.horizontalRange, j - this.verticalRange, k - this.horizontalRange, i + this.horizontalRange, j + this.verticalRange, k + this.horizontalRange)).distinct().filter(blockPos2 -> !blockPos2.equals((Object)blockPos)).ifPresent(cather -> {
            this.precalculatedTargets = new Catheter((Object[])new Target[cather.count()]).arrayGenerator(Target[]::new);
        }).whenAlternate((Object)0, (min, blockPos2) -> {
            int weight = class_3532.method_15384((double)blockPos.method_10262((class_2382)blockPos2));
            int max = min + weight;
            this.precalculatedTargets.fetch(this.precalculatingIndex++, (Object)new Target(blockPos2.method_10062(), weight, (int)min, max));
            return max;
        }, precalculatedRange -> {
            this.precalculatedRange = precalculatedRange;
        });
        if (this.targets.isPresent() && this.precalculatedRange / ((Target)this.precalculatedTargets.fetch(0)).weight() == this.precalculatedTargets.count()) {
            this.isNoRange = true;
        }
    }

    private static List<class_2338> makeBlockPos(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        ObjectArrayList blockPosList = ApricotCollectionFactor.arrayList();
        class_2338.method_10094((int)startX, (int)startY, (int)startZ, (int)endX, (int)endY, (int)endZ).forEach(((List)blockPosList)::add);
        return blockPosList;
    }

    protected void keepRunning(class_3218 serverWorld, E mobEntity, long l) {
        if (this.lastTarget == null) {
            --this.cooldown;
            this.findTarget(serverWorld, mobEntity, l);
        } else if (l - this.targetTime >= 40L) {
            mobEntity.method_36456(((class_1308)mobEntity).field_6283);
            mobEntity.method_35054(true);
            double d = this.lastTarget.method_1033();
            double e = d + (double)mobEntity.method_37416();
            mobEntity.method_18799(this.lastTarget.method_1021(e / d));
            mobEntity.method_18868().method_18878(class_4140.field_30245, (Object)true);
            serverWorld.method_43129(null, mobEntity, this.entityToSound.apply(mobEntity), class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    protected void findTarget(class_3218 world, E entity, long time) {
        while (this.targets.isPresent()) {
            class_243 vec3d2;
            Target target = this.getTarget(world);
            if (target == null || !this.canJumpTo(entity, target.pos) || (vec3d2 = this.getJumpingVelocity((class_1937)world, (class_1308)entity, class_243.method_24953((class_2382)target.pos))) == null) continue;
            entity.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(target.pos));
            class_11 path = entity.method_5942().method_35141(target.pos, 0, 8);
            if (path != null && path.method_21655()) continue;
            this.lastTarget = vec3d2;
            this.targetTime = time;
            return;
        }
    }

    protected Target getTarget(class_3218 world) {
        if (this.targets.isPresent()) {
            WeightingResult<Target> target;
            if (this.isNoRange) {
                int index = world.field_9229.method_43048(this.precalculatedTargets.count());
                target = new WeightingResult<Target>((Target)this.precalculatedTargets.fetch(index), index);
            } else {
                target = SepalsWeighting.getRandom(world.field_9229, this.precalculatedTargets, t -> this.precalculatedRange);
            }
            if (target == null) {
                return null;
            }
            this.targets.removeWithIndex(target.index());
            this.precalculatedTargets.removeWithIndex(target.index());
            Target value = target.value();
            if (value == null) {
                return null;
            }
            this.precalculatedRange -= value.weight();
            return value;
        }
        return null;
    }

    private boolean canJumpTo(E entity, class_2338 targetPos) {
        class_2338 entityPos = entity.method_24515();
        if (entityPos.method_10263() == targetPos.method_10263() && entityPos.method_10260() == targetPos.method_10260()) {
            return false;
        }
        return this.jumpToPredicate.test(entity, targetPos);
    }

    @Nullable
    protected class_243 getJumpingVelocity(class_1937 world, class_1308 entity, class_243 targetPos) {
        float f = (float)(entity.method_45325(class_5134.field_23728) * this.maxRange);
        SepalsLongJumpTask.shuffle(RAM_RANGES, world.field_9229);
        return class_8946.method_54990((class_1308)entity, (class_243)targetPos, (float)f, (int)RAM_RANGES[0], (boolean)true).orElseGet(() -> class_8946.method_54990((class_1308)entity, (class_243)targetPos, (float)f, (int)RAM_RANGES[1], (boolean)true).orElseGet(() -> class_8946.method_54990((class_1308)entity, (class_243)targetPos, (float)f, (int)RAM_RANGES[2], (boolean)true).orElseGet(() -> class_8946.method_54990((class_1308)entity, (class_243)targetPos, (float)f, (int)RAM_RANGES[3], (boolean)true).orElse(null))));
    }

    public static void shuffle(int[] ranges, class_5819 random) {
        int i;
        for (int j = i = ranges.length; j > 1; --j) {
            int to;
            int k = random.method_43048(j);
            int posFrom = j - 1;
            int from = ranges[posFrom];
            ranges[posFrom] = to = ranges[k];
            ranges[k] = from;
        }
    }

    public record Target(class_2338 pos, int weight, int min, int max) implements WeightTable<Target>
    {
        @Override
        public Target element() {
            return this;
        }
    }
}

