/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.entity.ai.task.composite;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.entity.ai.brain.DetailedDebuggableTask;
import com.github.cao.awa.sepals.entity.ai.brain.TaskDelegate;
import com.github.cao.awa.sepals.entity.ai.task.composite.SepalsTaskStatus;
import com.github.cao.awa.sepals.weight.WeightedList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_7893;

public class SepalsCompositeTask<E extends class_1309>
implements class_7893<E>,
TaskDelegate<E>,
DetailedDebuggableTask {
    private final Map<class_4140<?>, class_4141> requiredMemoryState;
    private final Set<class_4140<?>> memoriesToForgetWhenStopped;
    protected final Order order;
    protected final RunMode runMode;
    protected final WeightedList<class_7893<? super E>> tasks = new WeightedList();
    protected class_4097.class_4098 status = class_4097.class_4098.field_18337;

    public SepalsCompositeTask(Map<class_4140<?>, class_4141> requiredMemoryState, Set<class_4140<?>> memoriesToForgetWhenStopped, Order order, RunMode runMode, List<Pair<? extends class_7893<? super E>, Integer>> tasks) {
        this.requiredMemoryState = requiredMemoryState;
        this.memoriesToForgetWhenStopped = memoriesToForgetWhenStopped;
        this.order = order;
        this.runMode = runMode;
        tasks.forEach(task -> this.tasks.add((class_7893)task.getFirst(), (Integer)task.getSecond()));
    }

    public class_4097.class_4098 method_18921() {
        return this.status;
    }

    boolean shouldStart(E entity) {
        for (Map.Entry<class_4140<?>, class_4141> entry : this.requiredMemoryState.entrySet()) {
            class_4140<?> memoryModuleType = entry.getKey();
            class_4141 memoryModuleState = entry.getValue();
            if (entity.method_18868().method_18876(memoryModuleType, memoryModuleState)) continue;
            return false;
        }
        return true;
    }

    public boolean method_18922(class_3218 world, E entity, long time) {
        if (this.shouldStart(entity)) {
            this.status = class_4097.class_4098.field_18338;
            this.order.apply(this.tasks);
            this.runMode.run(this.tasks.elements(), world, entity, time);
            return true;
        }
        return false;
    }

    public final void method_18923(class_3218 world, E entity, long time) {
        this.tasks.elements().filter(SepalsTaskStatus::isRunning).ifEmpty(x -> this.method_18925(world, entity, time)).each(task -> task.method_18923(world, entity, time));
    }

    public final void method_18925(class_3218 world, E entity, long time) {
        this.status = class_4097.class_4098.field_18337;
        this.tasks.elements().filter(SepalsTaskStatus::isRunning).each(task -> task.method_18925(world, entity, time));
        this.memoriesToForgetWhenStopped.forEach(arg_0 -> ((class_4095)entity.method_18868()).method_18875(arg_0));
    }

    public String method_46910() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        Set set = this.tasks.elements().filter(SepalsTaskStatus::isRunning).set();
        return "(" + this.method_46910() + "): " + String.valueOf(set);
    }

    @Override
    public Catheter<class_7893<? super E>> sepals$tasks() {
        return this.tasks.elements();
    }

    @Override
    public String information() {
        String orderMode = this.order == Order.SHUFFLED ? "SHUFFLED" : "ORDERED";
        String runMode = this.runMode == RunMode.RUN_ONE ? "PICK ONCE" : "RUN ALL";
        return "CompositeTask(" + String.valueOf(this.status) + ", " + orderMode + ", " + runMode + ", tasks(count=" + this.tasks.size() + "))";
    }

    public static enum Order {
        ORDERED(list -> {}),
        SHUFFLED(WeightedList::shuffle);

        private final Consumer<WeightedList<?>> listModifier;

        private Order(Consumer<WeightedList<?>> listModifier) {
            this.listModifier = listModifier;
        }

        public void apply(WeightedList<?> list) {
            this.listModifier.accept(list);
        }
    }

    public static enum RunMode {
        RUN_ONE{

            @Override
            public <E extends class_1309> void run(Catheter<class_7893<? super E>> tasks, class_3218 world, E entity, long time) {
                tasks.filter(SepalsTaskStatus::isStopped).till(task -> task.method_18922(world, entity, time));
            }
        }
        ,
        TRY_ALL{

            @Override
            public <E extends class_1309> void run(Catheter<class_7893<? super E>> tasks, class_3218 world, E entity, long time) {
                tasks.filter(SepalsTaskStatus::isStopped).each(task -> task.method_18922(world, entity, time));
            }
        };


        public abstract <E extends class_1309> void run(Catheter<class_7893<? super E>> var1, class_3218 var2, E var3, long var4);
    }
}

