/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.mixin.world.poi;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.sepals.collection.listener.ActivableLong2ObjectMap;
import com.github.cao.awa.sepals.mixin.world.poi.PointOfInterestSetAccessor;
import com.github.cao.awa.sepals.world.poi.RegionBasedStorageSectionExtended;
import com.github.cao.awa.sepals.world.poi.SepalsPointOfInterestSet;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4180;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_9172;
import net.minecraft.class_9820;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4180.class})
public abstract class SerializingRegionBasedStorageMixin<R>
implements RegionBasedStorageSectionExtended<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> field_18692;
    @Shadow
    @Final
    protected class_5539 field_27240;
    @Unique
    private Map<Long, BitSet> columns;

    @Shadow
    protected abstract Optional<R> method_19294(long var1);

    @Shadow
    public abstract CompletableFuture<?> method_61780(class_1923 var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, order=0x7FFFFFFF)
    private void init(class_9172 storageAccess, Codec codec, Function serializer, BiFunction deserializer, Function factory, class_5455 registryManager, class_9820 errorHandler, class_5539 world, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.field_18692 = new ActivableLong2ObjectMap<Optional<R>>(this.field_18692).triggerPutAndRemoved(this::handlePut, this::handleRemoved);
    }

    @Unique
    private void handleRemoved(long key, Optional<R> value) {
        int z;
        int x;
        long pos;
        BitSet flags;
        int y = class_4076.method_18689((long)key) - this.field_27240.method_32891();
        if (y > -1 && y < this.field_27240.method_32890() && (flags = this.columns.get(pos = class_1923.method_8331((int)(x = class_4076.method_18686((long)key)), (int)(z = class_4076.method_18690((long)key))))) != null) {
            flags.clear(y);
            if (flags.isEmpty()) {
                this.columns.remove(pos);
            }
        }
    }

    @Unique
    private void handlePut(long key, Optional<R> value) {
        int y = class_4076.method_18689((long)key) - this.field_27240.method_32891();
        if (y > -1 && y < this.field_27240.method_32890()) {
            int x = class_4076.method_18686((long)key);
            int z = class_4076.method_18690((long)key);
            BitSet flags = this.columns.computeIfAbsent(class_1923.method_8331((int)x, (int)z), k -> new BitSet());
            flags.set(y, value.isPresent());
        }
    }

    @Override
    public Stream<class_4156> sepals$getInChunk(Predicate<class_6880<class_4158>> typePredicate, class_1923 chunkPos, class_4153.class_4155 occupationStatus) {
        return IntStream.rangeClosed(this.field_27240.method_32891(), this.field_27240.method_31597()).mapToObj(coordinate -> this.method_19294(class_4076.method_18681((class_1923)chunkPos, (int)coordinate).method_18694())).filter(Optional::isPresent).flatMap(poiSet -> SepalsPointOfInterestSet.get(((PointOfInterestSetAccessor)poiSet.get()).getPointsOfInterestByType(), typePredicate, occupationStatus).stream());
    }

    @Override
    public Catheter<R> sepals$getWithinChunkColumn(int x, int z) {
        BitSet sectionsWithPOI = this.getNonEmptyPOISections(x, z);
        if (sectionsWithPOI.isEmpty()) {
            return Catheter.make((Object[])new Object[0]);
        }
        ObjectArrayList list = ApricotCollectionFactor.arrayList();
        int minYSection = this.field_27240.method_32891();
        int chunkYIndex = sectionsWithPOI.nextSetBit(0);
        while (chunkYIndex != -1) {
            int chunkY = chunkYIndex + minYSection;
            Object r = ((Optional)this.field_18692.get(class_4076.method_18685((int)x, (int)chunkY, (int)z))).orElse(null);
            if (r != null) {
                list.add(r);
            }
            chunkYIndex = sectionsWithPOI.nextSetBit(chunkYIndex + 1);
        }
        return Catheter.of((Collection)list);
    }

    @Unique
    private BitSet getNonEmptyPOISections(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        BitSet flags = this.getNonEmptySections(pos, false);
        if (flags == null) {
            this.method_61780(new class_1923(pos));
            return this.getNonEmptySections(pos, true);
        }
        return flags;
    }

    @Unique
    private BitSet getNonEmptySections(long pos, boolean required) {
        BitSet set = this.columns.get(pos);
        if (set == null && required) {
            throw new NullPointerException("No data is present for column: " + String.valueOf(new class_1923(pos)));
        }
        return set;
    }
}

