/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.weight;

import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.catheter.receptacle.LongReceptacle;
import com.github.cao.awa.sepals.weight.result.WeightingResult;
import java.util.function.ToIntFunction;
import net.minecraft.class_156;
import net.minecraft.class_5819;

public class SepalsWeighting {
    public static <T> WeightingResult<T> getRandom(class_5819 random, Catheter<T> pool, ToIntFunction<T> weightGetter) {
        return SepalsWeighting.getRandom(random, pool, SepalsWeighting.getWeightSum(pool, weightGetter), weightGetter);
    }

    public static <T> int getWeightSum(Catheter<T> pool, ToIntFunction<T> weightGetter) {
        LongReceptacle weight = new LongReceptacle(0L);
        pool.whenFoundFirst(obj -> weight.set(weight.get() + (long)weightGetter.applyAsInt(obj)).get() >= 0L, t -> t);
        if (weight.get() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)weight.get();
    }

    public static <T> WeightingResult<T> getRandom(class_5819 random, Catheter<T> pool, int totalWeight, ToIntFunction<T> weightGetter) {
        if (totalWeight < 0) {
            throw (IllegalArgumentException)class_156.method_22320((Throwable)new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return null;
        }
        int i = random.method_43048(totalWeight);
        return SepalsWeighting.getAt(pool, i, weightGetter);
    }

    public static <T> WeightingResult<T> getAt(Catheter<T> pool, int totalWeight, ToIntFunction<T> weightGetter) {
        IntegerReceptacle weight = new IntegerReceptacle(totalWeight);
        Object result = pool.whenFoundFirst(obj -> weight.set(weight.get() - weightGetter.applyAsInt(obj)).get() >= 0, t -> t);
        return new WeightingResult<Object>(result, 0);
    }
}

